/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.childprocess.impl;

import com.julienviet.childprocess.Process;
import com.julienviet.childprocess.ProcessBuilder;
import com.julienviet.childprocess.ProcessOptions;
import com.julienviet.childprocess.StartException;
import com.julienviet.childprocess.impl.ProcessImpl;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProcessBuilderImpl
implements ProcessBuilder {
    private final ContextInternal context;
    private final String command;
    private final List<String> args;
    private final ProcessOptions options;
    private Handler<Process> processHandler;

    public ProcessBuilderImpl(ContextInternal context, String command, List<String> args, ProcessOptions options) {
        this.context = context;
        this.command = command;
        this.args = args;
        this.options = options;
    }

    @Override
    public Future<Void> start() {
        PromiseInternal promise = this.context.promise();
        HashMap env = new HashMap();
        if (this.options.getEnv() != null) {
            this.options.getEnv().entrySet().forEach(entry -> {
                if (entry.getValue() != null) {
                    env.put(entry.getKey(), entry.getValue());
                }
            });
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.command);
        commands.addAll(this.args);
        NuProcessBuilder builder = new NuProcessBuilder(commands, env);
        if (this.options.getCwd() != null) {
            builder.setCwd(new File(this.options.getCwd()).toPath());
        }
        Buffer bufferedStdout = Buffer.buffer();
        Buffer bufferedStderr = Buffer.buffer();
        final Handler<Process> handler = this.processHandler;
        builder.setProcessListener(new NuProcessHandler((Promise)promise, bufferedStdout, bufferedStderr){
            volatile ProcessImpl process;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ Buffer val$bufferedStdout;
            final /* synthetic */ Buffer val$bufferedStderr;
            {
                this.val$promise = promise;
                this.val$bufferedStdout = buffer;
                this.val$bufferedStderr = buffer2;
            }

            public void onPreStart(NuProcess nuProcess) {
            }

            public void onStart(NuProcess nuProcess) {
                ProcessImpl p;
                this.process = p = new ProcessImpl(ProcessBuilderImpl.this.context, nuProcess);
                if (handler != null) {
                    ProcessBuilderImpl.this.context.emit((Object)p, handler);
                }
                this.val$promise.complete();
            }

            public void onExit(int exitCode) {
                ProcessImpl p = this.process;
                if (p == null) {
                    this.val$promise.fail((Throwable)new StartException(exitCode, this.val$bufferedStdout, this.val$bufferedStderr));
                } else {
                    p.onExit(exitCode);
                }
            }

            private byte[] getBytes(ByteBuffer byteBuffer) {
                if (byteBuffer != null && byteBuffer.remaining() > 0) {
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                return null;
            }

            public void onStdout(ByteBuffer byteBuffer, boolean closed) {
                byte[] bytes = this.getBytes(byteBuffer);
                ProcessImpl p = this.process;
                if (this.process != null) {
                    p.onStdout(bytes != null ? Buffer.buffer((byte[])bytes) : null, closed);
                } else if (bytes != null) {
                    this.val$bufferedStdout.appendBytes(bytes);
                }
            }

            public void onStderr(ByteBuffer byteBuffer, boolean closed) {
                byte[] bytes = this.getBytes(byteBuffer);
                ProcessImpl p = this.process;
                if (p != null) {
                    p.onStderr(bytes != null ? Buffer.buffer((byte[])bytes) : null, closed);
                } else if (bytes != null) {
                    this.val$bufferedStdout.appendBytes(bytes);
                }
            }

            public boolean onStdinReady(ByteBuffer buffer) {
                ProcessImpl p = this.process;
                return p.onStdinReady(buffer);
            }
        });
        builder.start();
        return promise.future();
    }

    @Override
    public synchronized ProcessBuilder startHandler(Handler<Process> handler) {
        this.processHandler = handler;
        return this;
    }
}

