/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.childprocess.impl;

import com.julienviet.childprocess.StreamInput;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;

public class ProcessStreamInput
implements StreamInput {
    private final ContextInternal context;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;

    ProcessStreamInput(ContextInternal context) {
        this.context = context;
    }

    synchronized void write(Buffer buffer) {
        this.sendBuffer(buffer);
    }

    void close() {
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            this.context.emit(handler);
        }
    }

    private void sendBuffer(Buffer buffer) {
        Handler<Buffer> handler = this.dataHandler;
        if (handler != null) {
            this.context.emit((Object)buffer, handler);
        }
    }

    @Override
    public StreamInput exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public StreamInput handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public StreamInput endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

