/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.SimpleFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LDJavaUtilLogging
implements LDLogAdapter,
LDLogAdapter.IsConfiguredExternally {
    static final LDLogAdapter INSTANCE = new LDJavaUtilLogging();

    private LDJavaUtilLogging() {
    }

    @Override
    public LDLogAdapter.Channel newChannel(String name) {
        return new ChannelImpl(Logger.getLogger(name));
    }

    private static final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final Logger logger;

        ChannelImpl(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            switch (level) {
                case DEBUG: {
                    return this.logger.isLoggable(Level.FINE);
                }
                case INFO: {
                    return this.logger.isLoggable(Level.INFO);
                }
                case WARN: {
                    return this.logger.isLoggable(Level.WARNING);
                }
            }
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            if (this.isEnabled(level)) {
                this.logInternal(level, message == null ? "" : message.toString());
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format(format, param));
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format(format, param1, param2));
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format(format, params));
            }
        }

        private void logInternal(LDLogLevel level, String text) {
            switch (level) {
                case DEBUG: {
                    this.logger.fine(text);
                    break;
                }
                case INFO: {
                    this.logger.info(text);
                    break;
                }
                case WARN: {
                    this.logger.warning(text);
                    break;
                }
                case ERROR: {
                    this.logger.severe(text);
                    break;
                }
            }
        }
    }
}

