/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.SimpleFormat;
import com.launchdarkly.logging.SimpleLogging;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public final class LogCapture
implements LDLogAdapter {
    private final List<Message> messages = new ArrayList<Message>();
    private final Object messagesLock = new Object();

    LogCapture() {
    }

    @Override
    public LDLogAdapter.Channel newChannel(String name) {
        return new ChannelImpl(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() {
        Object object = this.messagesLock;
        synchronized (object) {
            return new ArrayList<Message>(this.messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessageStrings() {
        ArrayList<String> ret = new ArrayList<String>();
        Object object = this.messagesLock;
        synchronized (object) {
            for (Message m3 : this.messages) {
                ret.add(m3.getLevel().name() + ":" + m3.getText());
            }
        }
        return ret;
    }

    public Message awaitMessage(long timeoutMilliseconds) {
        return this.awaitMessage(null, timeoutMilliseconds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message awaitMessage(LDLogLevel level, long timeoutMilliseconds) {
        long deadline = System.currentTimeMillis() + timeoutMilliseconds;
        Object object = this.messagesLock;
        synchronized (object) {
            while (true) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    Message m3 = this.messages.get(i);
                    if (level != null && m3.level != level) continue;
                    this.messages.remove(i);
                    return m3;
                }
                long remainingTime = deadline - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    return null;
                }
                try {
                    this.messagesLock.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
    }

    public Message requireMessage(long timeoutMilliseconds) {
        return this.requireMessage(null, timeoutMilliseconds);
    }

    public Message requireMessage(LDLogLevel level, long timeoutMilliseconds) {
        Message m3 = this.awaitMessage(level, timeoutMilliseconds);
        if (m3 == null) {
            throw new AssertionError((Object)"expected a log message but did not get one");
        }
        return m3;
    }

    private final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final String name;

        ChannelImpl(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMessage(LDLogLevel level, String message) {
            Object object = LogCapture.this.messagesLock;
            synchronized (object) {
                LogCapture.this.messages.add(new Message(new Date(), this.name, level, message));
                LogCapture.this.messagesLock.notifyAll();
            }
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            return true;
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            this.addMessage(level, message == null ? "" : message.toString());
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            this.addMessage(level, SimpleFormat.format(format, param));
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            this.addMessage(level, SimpleFormat.format(format, param1, param2));
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            this.addMessage(level, SimpleFormat.format(format, params));
        }
    }

    public static final class Message {
        private final Date timestamp;
        private final String loggerName;
        private final LDLogLevel level;
        private final String text;

        public Message(Date timestamp, String loggerName, LDLogLevel level, String text) {
            this.timestamp = timestamp;
            this.loggerName = loggerName;
            this.level = level;
            this.text = text;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public LDLogLevel getLevel() {
            return this.level;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object other) {
            if (other instanceof Message) {
                Message o = (Message)other;
                return Objects.equals(this.timestamp, o.timestamp) && Objects.equals(this.loggerName, o.loggerName) && this.level == o.level && Objects.equals(this.text, o.text);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.timestamp, this.loggerName, this.level, this.text});
        }

        public String toString() {
            return "[" + this.loggerName + "] " + this.level.name() + ":" + this.text;
        }

        public String toStringWithTimestamp() {
            return SimpleLogging.getDefaultTimestampFormat().format(this.timestamp) + " " + this.toString();
        }
    }
}

