/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.google.common.graph;

import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.com.google.common.collect.UnmodifiableIterator;
import com.launchdarkly.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.launchdarkly.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    private volatile transient @Nullable Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CanIgnoreReturnValue
    public final V put(@Nullable K key, @Nullable V value) {
        this.clearCache();
        return this.backingMap.put(key, value);
    }

    @CanIgnoreReturnValue
    public final V remove(@Nullable Object key) {
        this.clearCache();
        return this.backingMap.remove(key);
    }

    public final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@Nullable Object key) {
        V value = this.getIfCached(key);
        return value != null ? value : this.getWithoutCaching(key);
    }

    public final V getWithoutCaching(@Nullable Object key) {
        return this.backingMap.get(key);
    }

    public final boolean containsKey(@Nullable Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.cacheEntry = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@Nullable Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    protected V getIfCached(@Nullable Object key) {
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == key) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.cacheEntry = null;
    }
}

