/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;

class LevelFilter
implements LDLogAdapter {
    final LDLogAdapter wrappedAdapter;
    private final LDLogLevel enableLevel;

    public LevelFilter(LDLogAdapter wrappedAdapter, LDLogLevel enableLevel) {
        this.wrappedAdapter = wrappedAdapter;
        this.enableLevel = enableLevel == null ? LDLogLevel.DEBUG : enableLevel;
    }

    @Override
    public LDLogAdapter.Channel newChannel(String name) {
        return new ChannelImpl(this.wrappedAdapter.newChannel(name));
    }

    private class ChannelImpl
    implements LDLogAdapter.Channel {
        private final LDLogAdapter.Channel wrappedChannel;

        public ChannelImpl(LDLogAdapter.Channel wrappedChannel) {
            this.wrappedChannel = wrappedChannel;
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            return LevelFilter.this.enableLevel.compareTo(level) <= 0 && this.wrappedChannel.isEnabled(level);
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            if (this.isEnabled(level)) {
                this.wrappedChannel.log(level, message);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            if (this.isEnabled(level)) {
                this.wrappedChannel.log(level, format, param);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            if (this.isEnabled(level)) {
                this.wrappedChannel.log(level, format, param1, param2);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            if (this.isEnabled(level)) {
                this.wrappedChannel.log(level, format, params);
            }
        }
    }
}

