/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.integrations.ApplicationInfoBuilder;
import com.launchdarkly.sdk.server.integrations.BigSegmentsConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;

public abstract class Components {
    private Components() {
    }

    public static BigSegmentsConfigurationBuilder bigSegments(ComponentConfigurer<BigSegmentStore> storeConfigurer) {
        return new BigSegmentsConfigurationBuilder(storeConfigurer);
    }

    public static ComponentConfigurer<DataStore> inMemoryDataStore() {
        return ComponentsImpl.InMemoryDataStoreFactory.INSTANCE;
    }

    public static PersistentDataStoreBuilder persistentDataStore(ComponentConfigurer<PersistentDataStore> storeConfigurer) {
        return new ComponentsImpl.PersistentDataStoreBuilderImpl(storeConfigurer);
    }

    public static EventProcessorBuilder sendEvents() {
        return new ComponentsImpl.EventProcessorBuilderImpl();
    }

    public static ComponentConfigurer<EventProcessor> noEvents() {
        return ComponentsImpl.NULL_EVENT_PROCESSOR_FACTORY;
    }

    public static StreamingDataSourceBuilder streamingDataSource() {
        return new ComponentsImpl.StreamingDataSourceBuilderImpl();
    }

    public static PollingDataSourceBuilder pollingDataSource() {
        return new ComponentsImpl.PollingDataSourceBuilderImpl();
    }

    static ComponentsImpl.PollingDataSourceBuilderImpl pollingDataSourceInternal() {
        return new ComponentsImpl.PollingDataSourceBuilderImpl();
    }

    public static ComponentConfigurer<DataSource> externalUpdatesOnly() {
        return ComponentsImpl.NullDataSourceFactory.INSTANCE;
    }

    public static HttpConfigurationBuilder httpConfiguration() {
        return new ComponentsImpl.HttpConfigurationBuilderImpl();
    }

    public static HttpAuthentication httpBasicAuthentication(String username, String password) {
        return new ComponentsImpl.HttpBasicAuthentication(username, password);
    }

    public static LoggingConfigurationBuilder logging() {
        return new ComponentsImpl.LoggingConfigurationBuilderImpl();
    }

    public static LoggingConfigurationBuilder logging(LDLogAdapter logAdapter) {
        return Components.logging().adapter(logAdapter);
    }

    public static LoggingConfigurationBuilder noLogging() {
        return Components.logging().adapter(Logs.none());
    }

    public static ApplicationInfoBuilder applicationInfo() {
        return new ApplicationInfoBuilder();
    }

    public static ServiceEndpointsBuilder serviceEndpoints() {
        return new ComponentsImpl.ServiceEndpointsBuilderImpl();
    }
}

