/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.DataModelSerialization;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DataModel {
    public static DataStoreTypes.DataKind FEATURES = new DataStoreTypes.DataKind("features", DataModel::serializeItem, s2 -> DataModel.deserializeItem(s2, FeatureFlag.class));
    public static DataStoreTypes.DataKind SEGMENTS = new DataStoreTypes.DataKind("segments", DataModel::serializeItem, s2 -> DataModel.deserializeItem(s2, Segment.class));
    public static Iterable<DataStoreTypes.DataKind> ALL_DATA_KINDS = ImmutableList.of(FEATURES, SEGMENTS);

    private DataModel() {
    }

    private static DataStoreTypes.ItemDescriptor deserializeItem(String s2, Class<? extends VersionedData> itemClass) {
        VersionedData o = JsonHelpers.deserialize(s2, itemClass);
        return o.isDeleted() ? DataStoreTypes.ItemDescriptor.deletedItem(o.getVersion()) : new DataStoreTypes.ItemDescriptor(o.getVersion(), o);
    }

    private static String serializeItem(DataStoreTypes.ItemDescriptor item) {
        Object o = item.getItem();
        if (o != null) {
            return JsonHelpers.serialize(o);
        }
        return "{\"version\":" + item.getVersion() + ",\"deleted\":true}";
    }

    static enum RolloutKind {
        rollout,
        experiment;

    }

    static class Operator {
        private final String name;
        private final boolean builtin;
        private final int hashCode;
        private static final Map<String, Operator> builtins = new HashMap<String, Operator>();
        static final Operator in = Operator.builtin("in");
        static final Operator startsWith = Operator.builtin("startsWith");
        static final Operator endsWith = Operator.builtin("endsWith");
        static final Operator matches = Operator.builtin("matches");
        static final Operator contains = Operator.builtin("contains");
        static final Operator lessThan = Operator.builtin("lessThan");
        static final Operator lessThanOrEqual = Operator.builtin("lessThanOrEqual");
        static final Operator greaterThan = Operator.builtin("greaterThan");
        static final Operator greaterThanOrEqual = Operator.builtin("greaterThanOrEqual");
        static final Operator before = Operator.builtin("before");
        static final Operator after = Operator.builtin("after");
        static final Operator semVerEqual = Operator.builtin("semVerEqual");
        static final Operator semVerLessThan = Operator.builtin("semVerLessThan");
        static final Operator semVerGreaterThan = Operator.builtin("semVerGreaterThan");
        static final Operator segmentMatch = Operator.builtin("segmentMatch");

        private Operator(String name, boolean builtin) {
            this.name = name;
            this.builtin = builtin;
            this.hashCode = name.hashCode();
        }

        private static Operator builtin(String name) {
            Operator op = new Operator(name, true);
            builtins.put(name, op);
            return op;
        }

        static Operator forName(String name) {
            Operator op = builtins.get(name);
            return op == null ? new Operator(name, false) : op;
        }

        static Iterable<Operator> getBuiltins() {
            return builtins.values();
        }

        String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this.builtin) {
                return this == other;
            }
            return other instanceof Operator && ((Operator)other).name.equals(this.name);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class SegmentTarget {
        private ContextKind contextKind;
        private Set<String> values;

        SegmentTarget(ContextKind contextKind, Set<String> values2) {
            this.contextKind = contextKind;
            this.values = values2;
        }

        ContextKind getContextKind() {
            return this.contextKind;
        }

        Set<String> getValues() {
            return this.values == null ? Collections.emptySet() : this.values;
        }
    }

    @JsonAdapter(value=DataModelSerialization.SegmentRuleTypeAdapter.class)
    static final class SegmentRule {
        private final List<Clause> clauses;
        private final Integer weight;
        private final ContextKind rolloutContextKind;
        private final AttributeRef bucketBy;

        SegmentRule(List<Clause> clauses, Integer weight, ContextKind rolloutContextKind, AttributeRef bucketBy) {
            this.clauses = clauses == null ? Collections.emptyList() : clauses;
            this.weight = weight;
            this.rolloutContextKind = rolloutContextKind;
            this.bucketBy = bucketBy;
        }

        List<Clause> getClauses() {
            return this.clauses;
        }

        Integer getWeight() {
            return this.weight;
        }

        ContextKind getRolloutContextKind() {
            return this.rolloutContextKind;
        }

        AttributeRef getBucketBy() {
            return this.bucketBy;
        }
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static final class Segment
    implements VersionedData,
    JsonHelpers.PostProcessingDeserializable {
        private String key;
        private Set<String> included;
        private Set<String> excluded;
        private List<SegmentTarget> includedContexts;
        private List<SegmentTarget> excludedContexts;
        private String salt;
        private List<SegmentRule> rules;
        private int version;
        private boolean deleted;
        private boolean unbounded;
        private ContextKind unboundedContextKind;
        private Integer generation;

        Segment() {
        }

        Segment(String key, Set<String> included, Set<String> excluded, List<SegmentTarget> includedContexts, List<SegmentTarget> excludedContexts, String salt, List<SegmentRule> rules, int version, boolean deleted, boolean unbounded, ContextKind unboundedContextKind, Integer generation) {
            this.key = key;
            this.included = included;
            this.excluded = excluded;
            this.includedContexts = includedContexts;
            this.excludedContexts = excludedContexts;
            this.salt = salt;
            this.rules = rules;
            this.version = version;
            this.deleted = deleted;
            this.unbounded = unbounded;
            this.unboundedContextKind = unboundedContextKind;
            this.generation = generation;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        Collection<String> getIncluded() {
            return this.included == null ? Collections.emptySet() : this.included;
        }

        Collection<String> getExcluded() {
            return this.excluded == null ? Collections.emptySet() : this.excluded;
        }

        List<SegmentTarget> getIncludedContexts() {
            return this.includedContexts == null ? Collections.emptyList() : this.includedContexts;
        }

        List<SegmentTarget> getExcludedContexts() {
            return this.excludedContexts == null ? Collections.emptyList() : this.excludedContexts;
        }

        String getSalt() {
            return this.salt;
        }

        List<SegmentRule> getRules() {
            return this.rules == null ? Collections.emptyList() : this.rules;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isUnbounded() {
            return this.unbounded;
        }

        public ContextKind getUnboundedContextKind() {
            return this.unboundedContextKind;
        }

        public Integer getGeneration() {
            return this.generation;
        }

        @Override
        public void afterDeserialized() {
            DataModelPreprocessing.preprocessSegment(this);
        }
    }

    static final class WeightedVariation {
        private int variation;
        private int weight;
        private boolean untracked;

        WeightedVariation() {
        }

        WeightedVariation(int variation, int weight, boolean untracked) {
            this.variation = variation;
            this.weight = weight;
            this.untracked = untracked;
        }

        int getVariation() {
            return this.variation;
        }

        int getWeight() {
            return this.weight;
        }

        boolean isUntracked() {
            return this.untracked;
        }
    }

    static class VariationOrRollout {
        private Integer variation;
        private Rollout rollout;

        VariationOrRollout() {
        }

        VariationOrRollout(Integer variation, Rollout rollout) {
            this.variation = variation;
            this.rollout = rollout;
        }

        Integer getVariation() {
            return this.variation;
        }

        Rollout getRollout() {
            return this.rollout;
        }
    }

    @JsonAdapter(value=DataModelSerialization.RolloutTypeAdapter.class)
    static final class Rollout {
        private final ContextKind contextKind;
        private final List<WeightedVariation> variations;
        private final AttributeRef bucketBy;
        private final RolloutKind kind;
        private final Integer seed;

        Rollout(ContextKind contextKind, List<WeightedVariation> variations, AttributeRef bucketBy, RolloutKind kind, Integer seed) {
            this.contextKind = contextKind;
            this.variations = variations == null ? Collections.emptyList() : variations;
            this.bucketBy = bucketBy;
            this.kind = kind;
            this.seed = seed;
        }

        ContextKind getContextKind() {
            return this.contextKind;
        }

        List<WeightedVariation> getVariations() {
            return this.variations;
        }

        AttributeRef getBucketBy() {
            return this.bucketBy;
        }

        RolloutKind getKind() {
            return this.kind;
        }

        Integer getSeed() {
            return this.seed;
        }

        boolean isExperiment() {
            return this.kind == RolloutKind.experiment;
        }
    }

    @JsonAdapter(value=DataModelSerialization.ClauseTypeAdapter.class)
    static final class Clause {
        private final ContextKind contextKind;
        private final AttributeRef attribute;
        private final Operator op;
        private final List<LDValue> values;
        private final boolean negate;
        transient DataModelPreprocessing.ClausePreprocessed preprocessed;

        Clause(ContextKind contextKind, AttributeRef attribute, Operator op, List<LDValue> values2, boolean negate) {
            this.contextKind = contextKind;
            this.attribute = attribute;
            this.op = op;
            this.values = values2 == null ? Collections.emptyList() : values2;
            this.negate = negate;
        }

        ContextKind getContextKind() {
            return this.contextKind;
        }

        AttributeRef getAttribute() {
            return this.attribute;
        }

        Operator getOp() {
            return this.op;
        }

        List<LDValue> getValues() {
            return this.values;
        }

        boolean isNegate() {
            return this.negate;
        }
    }

    static final class Rule
    extends VariationOrRollout {
        private String id;
        private List<Clause> clauses;
        private boolean trackEvents;
        transient DataModelPreprocessing.FlagRulePreprocessed preprocessed;

        Rule() {
        }

        Rule(String id, List<Clause> clauses, Integer variation, Rollout rollout, boolean trackEvents) {
            super(variation, rollout);
            this.id = id;
            this.clauses = clauses;
            this.trackEvents = trackEvents;
        }

        String getId() {
            return this.id;
        }

        List<Clause> getClauses() {
            return this.clauses == null ? Collections.emptyList() : this.clauses;
        }

        boolean isTrackEvents() {
            return this.trackEvents;
        }
    }

    static final class Target {
        private ContextKind contextKind;
        private Set<String> values;
        private int variation;
        transient DataModelPreprocessing.TargetPreprocessed preprocessed;

        Target() {
        }

        Target(ContextKind contextKind, Set<String> values2, int variation) {
            this.contextKind = contextKind;
            this.values = values2;
            this.variation = variation;
        }

        ContextKind getContextKind() {
            return this.contextKind;
        }

        Collection<String> getValues() {
            return this.values == null ? Collections.emptySet() : this.values;
        }

        int getVariation() {
            return this.variation;
        }
    }

    static final class Prerequisite {
        private String key;
        private int variation;
        transient DataModelPreprocessing.PrerequisitePreprocessed preprocessed;

        Prerequisite() {
        }

        Prerequisite(String key, int variation) {
            this.key = key;
            this.variation = variation;
        }

        String getKey() {
            return this.key;
        }

        int getVariation() {
            return this.variation;
        }
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static final class FeatureFlag
    implements VersionedData,
    JsonHelpers.PostProcessingDeserializable {
        private String key;
        private int version;
        private boolean on;
        private List<Prerequisite> prerequisites;
        private String salt;
        private List<Target> targets;
        private List<Target> contextTargets;
        private List<Rule> rules;
        private VariationOrRollout fallthrough;
        private Integer offVariation;
        private List<LDValue> variations;
        private boolean clientSide;
        private boolean trackEvents;
        private boolean trackEventsFallthrough;
        private Long debugEventsUntilDate;
        private boolean deleted;
        transient DataModelPreprocessing.FlagPreprocessed preprocessed;

        FeatureFlag() {
        }

        FeatureFlag(String key, int version, boolean on, List<Prerequisite> prerequisites, String salt, List<Target> targets, List<Target> contextTargets, List<Rule> rules, VariationOrRollout fallthrough, Integer offVariation, List<LDValue> variations, boolean clientSide, boolean trackEvents, boolean trackEventsFallthrough, Long debugEventsUntilDate, boolean deleted) {
            this.key = key;
            this.version = version;
            this.on = on;
            this.prerequisites = prerequisites;
            this.salt = salt;
            this.targets = targets;
            this.contextTargets = contextTargets;
            this.rules = rules;
            this.fallthrough = fallthrough;
            this.offVariation = offVariation;
            this.variations = variations;
            this.clientSide = clientSide;
            this.trackEvents = trackEvents;
            this.trackEventsFallthrough = trackEventsFallthrough;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.deleted = deleted;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        boolean isTrackEvents() {
            return this.trackEvents;
        }

        boolean isTrackEventsFallthrough() {
            return this.trackEventsFallthrough;
        }

        Long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        boolean isOn() {
            return this.on;
        }

        List<Prerequisite> getPrerequisites() {
            return this.prerequisites == null ? Collections.emptyList() : this.prerequisites;
        }

        String getSalt() {
            return this.salt;
        }

        List<Target> getTargets() {
            return this.targets == null ? Collections.emptyList() : this.targets;
        }

        List<Target> getContextTargets() {
            return this.contextTargets == null ? Collections.emptyList() : this.contextTargets;
        }

        List<Rule> getRules() {
            return this.rules == null ? Collections.emptyList() : this.rules;
        }

        VariationOrRollout getFallthrough() {
            return this.fallthrough;
        }

        List<LDValue> getVariations() {
            return this.variations == null ? Collections.emptyList() : this.variations;
        }

        Integer getOffVariation() {
            return this.offVariation;
        }

        boolean isClientSide() {
            return this.clientSide;
        }

        @Override
        public void afterDeserialized() {
            DataModelPreprocessing.preprocessFlag(this);
        }
    }

    static interface VersionedData {
        public String getKey();

        public int getVersion();

        public boolean isDeleted();
    }
}

