/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvaluatorTypeConversion;
import com.launchdarkly.sdk.server.SemanticVersion;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

abstract class EvaluatorOperators {
    private static final Map<DataModel.Operator, OperatorFn> OPERATORS = new HashMap<DataModel.Operator, OperatorFn>();

    private EvaluatorOperators() {
    }

    static boolean apply(DataModel.Operator op, LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        OperatorFn fn = OPERATORS.get(op);
        return fn != null && fn.match(userValue, clauseValue, preprocessed);
    }

    static boolean applyIn(LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        return userValue.equals(clauseValue);
    }

    static boolean applyStartsWith(LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        return userValue.isString() && clauseValue.isString() && userValue.stringValue().startsWith(clauseValue.stringValue());
    }

    static boolean applyEndsWith(LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        return userValue.isString() && clauseValue.isString() && userValue.stringValue().endsWith(clauseValue.stringValue());
    }

    static boolean applyMatches(LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        Pattern clausePattern = preprocessed == null ? EvaluatorTypeConversion.valueToRegex(clauseValue) : preprocessed.parsedRegex;
        return clausePattern != null && userValue.isString() && clausePattern.matcher(userValue.stringValue()).find();
    }

    static boolean applyContains(LDValue userValue, LDValue clauseValue, DataModelPreprocessing.ClausePreprocessed.ValueData preprocessed) {
        return userValue.isString() && clauseValue.isString() && userValue.stringValue().contains(clauseValue.stringValue());
    }

    static OperatorFn numericComparison(Function<Integer, Boolean> comparisonTest) {
        return (userValue, clauseValue, preprocessed) -> {
            double n2;
            if (!userValue.isNumber() || !clauseValue.isNumber()) {
                return false;
            }
            double n1 = userValue.doubleValue();
            int delta = n1 == (n2 = clauseValue.doubleValue()) ? 0 : (n1 < n2 ? -1 : 1);
            return (Boolean)comparisonTest.apply(delta);
        };
    }

    static OperatorFn dateComparison(Function<Integer, Boolean> comparisonTest) {
        return (userValue, clauseValue, preprocessed) -> {
            Instant clauseDate;
            Instant instant = clauseDate = preprocessed == null ? EvaluatorTypeConversion.valueToDateTime(clauseValue) : preprocessed.parsedDate;
            if (clauseDate == null) {
                return false;
            }
            Instant userDate = EvaluatorTypeConversion.valueToDateTime(userValue);
            if (userDate == null) {
                return false;
            }
            return (Boolean)comparisonTest.apply(userDate.compareTo(clauseDate));
        };
    }

    static OperatorFn semVerComparison(Function<Integer, Boolean> comparisonTest) {
        return (userValue, clauseValue, preprocessed) -> {
            SemanticVersion clauseVer;
            SemanticVersion semanticVersion = clauseVer = preprocessed == null ? EvaluatorTypeConversion.valueToSemVer(clauseValue) : preprocessed.parsedSemVer;
            if (clauseVer == null) {
                return false;
            }
            SemanticVersion userVer = EvaluatorTypeConversion.valueToSemVer(userValue);
            if (userVer == null) {
                return false;
            }
            return (Boolean)comparisonTest.apply(userVer.compareTo(clauseVer));
        };
    }

    static {
        OPERATORS.put(DataModel.Operator.in, EvaluatorOperators::applyIn);
        OPERATORS.put(DataModel.Operator.startsWith, EvaluatorOperators::applyStartsWith);
        OPERATORS.put(DataModel.Operator.endsWith, EvaluatorOperators::applyEndsWith);
        OPERATORS.put(DataModel.Operator.matches, EvaluatorOperators::applyMatches);
        OPERATORS.put(DataModel.Operator.contains, EvaluatorOperators::applyContains);
        OPERATORS.put(DataModel.Operator.lessThan, EvaluatorOperators.numericComparison(delta -> delta < 0));
        OPERATORS.put(DataModel.Operator.lessThanOrEqual, EvaluatorOperators.numericComparison(delta -> delta <= 0));
        OPERATORS.put(DataModel.Operator.greaterThan, EvaluatorOperators.numericComparison(delta -> delta > 0));
        OPERATORS.put(DataModel.Operator.greaterThanOrEqual, EvaluatorOperators.numericComparison(delta -> delta >= 0));
        OPERATORS.put(DataModel.Operator.before, EvaluatorOperators.dateComparison(delta -> delta < 0));
        OPERATORS.put(DataModel.Operator.after, EvaluatorOperators.dateComparison(delta -> delta > 0));
        OPERATORS.put(DataModel.Operator.semVerEqual, EvaluatorOperators.semVerComparison(delta -> delta == 0));
        OPERATORS.put(DataModel.Operator.semVerLessThan, EvaluatorOperators.semVerComparison(delta -> delta < 0));
        OPERATORS.put(DataModel.Operator.semVerGreaterThan, EvaluatorOperators.semVerComparison(delta -> delta > 0));
    }

    private static interface OperatorFn {
        public boolean match(LDValue var1, LDValue var2, DataModelPreprocessing.ClausePreprocessed.ValueData var3);
    }
}

