/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.BufferedLineParser;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.LazyStackTrace;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Set;
import java.util.regex.Pattern;

final class EventParser {
    static final int VALUE_BUFFER_INITIAL_CAPACITY = 1000;
    private static final int MIN_READ_BUFFER_SIZE = 200;
    private static final String DATA = "data";
    private static final String EVENT = "event";
    private static final String ID = "id";
    private static final String RETRY = "retry";
    private static final String COMMENT = "";
    private static final Pattern DIGITS_ONLY = Pattern.compile("^[\\d]+$");
    private final EventHandler handler;
    private final ConnectionHandler connectionHandler;
    private final boolean streamEventData;
    private Set<String> expectFields;
    private final LDLogger logger;
    private final URI origin;
    private BufferedLineParser lineParser;
    private ByteArrayOutputStream dataBuffer;
    private ByteArrayOutputStream valueBuffer;
    private boolean haveData;
    private boolean dataLineEnded;
    private PipedOutputStream writingDataStream;
    private String fieldName;
    private String lastEventId;
    private String eventName;
    private boolean skipRestOfLine;

    EventParser(InputStream inputStream2, URI origin, EventHandler handler, ConnectionHandler connectionHandler, int readBufferSize, boolean streamEventData, Set<String> expectFields, LDLogger logger) {
        this.lineParser = new BufferedLineParser(inputStream2, readBufferSize < 200 ? 200 : readBufferSize);
        this.handler = handler;
        this.origin = origin;
        this.connectionHandler = connectionHandler;
        this.streamEventData = streamEventData;
        this.expectFields = expectFields;
        this.logger = logger;
        this.dataBuffer = new ByteArrayOutputStream(1000);
    }

    public boolean isEof() {
        return this.lineParser.isEof();
    }

    public boolean processStream() throws IOException {
        String fieldValue;
        boolean lineEnded = this.lineParser.read();
        byte[] chunkData = this.lineParser.getBuffer();
        int chunkOffset = this.lineParser.getChunkOffset();
        int chunkSize = this.lineParser.getChunkSize();
        if (this.skipRestOfLine) {
            this.skipRestOfLine = !lineEnded;
            return true;
        }
        if (chunkSize == 0) {
            if (lineEnded) {
                this.eventTerminated();
                return true;
            }
            return false;
        }
        int valueOffset = chunkOffset;
        int valueLength = chunkSize;
        if (this.fieldName == null) {
            int nameLength;
            for (nameLength = 0; nameLength < chunkSize && chunkData[chunkOffset + nameLength] != 58; ++nameLength) {
            }
            this.resetValueBuffer();
            if (nameLength == chunkSize && !lineEnded) {
                this.skipRestOfLine = true;
                return true;
            }
            String string = this.fieldName = nameLength == 0 ? COMMENT : new String(chunkData, chunkOffset, nameLength, Helpers.UTF8);
            if (nameLength < chunkSize && ++nameLength < chunkSize && chunkData[chunkOffset + nameLength] == 32) {
                ++nameLength;
            }
            valueOffset += nameLength;
            valueLength -= nameLength;
        }
        if (this.fieldName.equals(DATA)) {
            if (this.writingDataStream != null) {
                try {
                    if (this.dataLineEnded) {
                        this.writingDataStream.write(10);
                    }
                    this.writingDataStream.write(chunkData, valueOffset, valueLength);
                }
                catch (IOException nameLength) {}
            } else if (this.canStreamEventDataNow()) {
                this.writingDataStream = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream(this.writingDataStream);
                MessageEvent event = new MessageEvent(this.eventName, new InputStreamReader(pipedInputStream), this.lastEventId, this.origin);
                this.dispatchMessage(event);
                try {
                    this.writingDataStream.write(chunkData, valueOffset, valueLength);
                }
                catch (IOException iOException) {}
            } else {
                if (this.dataLineEnded) {
                    this.dataBuffer.write(10);
                }
                if (valueLength != 0) {
                    this.dataBuffer.write(chunkData, valueOffset, valueLength);
                }
            }
            this.dataLineEnded = lineEnded;
            this.haveData = true;
            if (lineEnded) {
                this.fieldName = null;
            }
            return true;
        }
        if (!lineEnded) {
            if (this.valueBuffer == null) {
                this.valueBuffer = new ByteArrayOutputStream(1000);
            }
            this.valueBuffer.write(chunkData, valueOffset, valueLength);
            return true;
        }
        if (this.valueBuffer == null || this.valueBuffer.size() == 0) {
            fieldValue = chunkSize == 0 ? COMMENT : new String(chunkData, valueOffset, valueLength, Helpers.UTF8);
        } else {
            this.valueBuffer.write(chunkData, valueOffset, valueLength);
            fieldValue = this.valueBuffer.toString(Helpers.UTF8.name());
            this.resetValueBuffer();
        }
        switch (this.fieldName) {
            case "": {
                this.processComment(fieldValue);
                break;
            }
            case "event": {
                this.eventName = fieldValue;
                break;
            }
            case "id": {
                if (fieldValue.contains("\u0000")) break;
                this.lastEventId = fieldValue;
                if (this.lastEventId == null) break;
                this.connectionHandler.setLastEventId(this.lastEventId);
                break;
            }
            case "retry": {
                if (!DIGITS_ONLY.matcher(fieldValue).matches()) break;
                this.connectionHandler.setReconnectTimeMillis(Long.parseLong(fieldValue));
                break;
            }
        }
        this.fieldName = null;
        return true;
    }

    private boolean canStreamEventDataNow() {
        if (!this.streamEventData) {
            return false;
        }
        if (this.expectFields != null) {
            if (this.expectFields.contains(EVENT) && this.eventName == null) {
                return false;
            }
            if (this.expectFields.contains(ID) && this.lastEventId == null) {
                return false;
            }
        }
        return true;
    }

    private void processComment(String comment) {
        try {
            this.handler.onComment(comment);
        }
        catch (Exception e) {
            this.logger.warn("Message handler threw an exception: " + e.toString());
            this.logger.debug("Stack trace: {}", (Object)new LazyStackTrace(e));
            this.handler.onError(e);
        }
    }

    private void eventTerminated() throws UnsupportedEncodingException {
        if (this.writingDataStream != null) {
            try {
                this.writingDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writingDataStream = null;
            this.resetState();
            return;
        }
        if (!this.haveData) {
            this.resetState();
            return;
        }
        String dataString = this.dataBuffer.toString(Helpers.UTF8.name());
        MessageEvent message = new MessageEvent(this.eventName, dataString, this.lastEventId, this.origin);
        if (this.lastEventId != null) {
            this.connectionHandler.setLastEventId(this.lastEventId);
        }
        this.dispatchMessage(message);
        this.resetState();
    }

    private void dispatchMessage(MessageEvent message) {
        try {
            this.logger.debug("Dispatching message: {}", (Object)message);
            this.handler.onMessage(message.getEventName(), message);
        }
        catch (Exception e) {
            this.logger.warn("Message handler threw an exception: " + e.toString());
            this.logger.debug("Stack trace: {}", (Object)new LazyStackTrace(e));
            this.handler.onError(e);
        }
    }

    private void resetState() {
        this.haveData = false;
        this.dataLineEnded = false;
        this.eventName = null;
        this.resetValueBuffer();
        if (this.dataBuffer.size() != 0) {
            if (this.dataBuffer.size() > 1000) {
                this.dataBuffer = new ByteArrayOutputStream(1000);
            } else {
                this.dataBuffer.reset();
            }
        }
    }

    private void resetValueBuffer() {
        if (this.valueBuffer != null) {
            if (this.valueBuffer.size() > 1000) {
                this.valueBuffer = null;
            } else {
                this.valueBuffer.reset();
            }
        }
    }
}

