/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Call;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.HttpUrl;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EventSource
implements Closeable {
    final LDLogger logger;
    public static final long DEFAULT_RECONNECT_TIME_MILLIS = 1000L;
    public static final long DEFAULT_MAX_RECONNECT_TIME_MILLIS = 30000L;
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = 10000L;
    public static final long DEFAULT_WRITE_TIMEOUT_MILLIS = 5000L;
    public static final long DEFAULT_READ_TIMEOUT_MILLIS = 5000L;
    public static final long DEFAULT_BACKOFF_RESET_THRESHOLD_MILLIS = 60000L;
    public static final int DEFAULT_READ_BUFFER_SIZE = 1000;
    private static final Headers defaultHeaders = new Headers.Builder().add("Accept", "text/event-stream").add("Cache-Control", "no-cache").build();
    private final String name;
    private volatile HttpUrl url;
    private final Headers headers;
    private final String method;
    private final RequestBody body;
    private final RequestTransformer requestTransformer;
    private final ExecutorService eventExecutor;
    private final ExecutorService streamExecutor;
    final int readBufferSize;
    volatile long reconnectTimeMillis;
    final long maxReconnectTimeMillis;
    final long backoffResetThresholdMillis;
    private volatile String lastEventId;
    final AsyncEventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    final boolean streamEventData;
    final Set<String> expectFields;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final SecureRandom jitter = new SecureRandom();

    EventSource(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.logger = builder.logger == null ? LDLogger.none() : builder.logger;
        this.url = builder.url;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.method = builder.method;
        this.body = builder.body;
        this.requestTransformer = builder.requestTransformer;
        this.lastEventId = builder.lastEventId;
        this.reconnectTimeMillis = builder.reconnectTimeMillis;
        this.maxReconnectTimeMillis = builder.maxReconnectTimeMillis;
        this.backoffResetThresholdMillis = builder.backoffResetThresholdMillis;
        this.streamEventData = builder.streamEventData;
        this.expectFields = builder.expectFields;
        ThreadFactory eventsThreadFactory = this.createThreadFactory("okhttp-eventsource-events", builder.threadPriority);
        this.eventExecutor = Executors.newSingleThreadExecutor(eventsThreadFactory);
        ThreadFactory streamThreadFactory = this.createThreadFactory("okhttp-eventsource-stream", builder.threadPriority);
        this.streamExecutor = Executors.newSingleThreadExecutor(streamThreadFactory);
        Semaphore eventThreadSemaphore = builder.maxEventTasksInFlight > 0 ? new Semaphore(builder.maxEventTasksInFlight) : null;
        this.handler = new AsyncEventHandler(this.eventExecutor, builder.handler, this.logger, eventThreadSemaphore);
        this.connectionErrorHandler = builder.connectionErrorHandler == null ? ConnectionErrorHandler.DEFAULT : builder.connectionErrorHandler;
        this.readBufferSize = builder.readBufferSize;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.clientBuilder.build();
    }

    private ThreadFactory createThreadFactory(String type, Integer threadPriority) {
        ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        AtomicLong count = new AtomicLong(0L);
        return runnable2 -> {
            Thread thread2 = backingThreadFactory.newThread(runnable2);
            thread2.setName(String.format(Locale.ROOT, "%s-[%s]-%d", type, this.name, count.getAndIncrement()));
            thread2.setDaemon(true);
            if (threadPriority != null) {
                thread2.setPriority(threadPriority);
            }
            return thread2;
        };
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            this.logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.RAW, (Object)ReadyState.CONNECTING);
        this.logger.info("Starting EventSource client using URI: {}", (Object)this.url);
        this.streamExecutor.execute(this::run);
    }

    public void restart() {
        ReadyState previousState = this.readyState.getAndUpdate(t -> t == ReadyState.OPEN ? ReadyState.CLOSED : t);
        if (previousState == ReadyState.OPEN) {
            this.closeCurrentStream(previousState);
        } else if (previousState == ReadyState.RAW) {
            this.start();
        }
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        this.logger.debug("readyState change: {} -> {}", (Object)currentState, (Object)ReadyState.SHUTDOWN);
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.closeCurrentStream(currentState);
        this.eventExecutor.shutdown();
        this.streamExecutor.shutdown();
        if (this.client.connectionPool() != null) {
            this.client.connectionPool().evictAll();
        }
        if (this.client.dispatcher() != null) {
            this.client.dispatcher().cancelAll();
            if (this.client.dispatcher().executorService() != null) {
                this.client.dispatcher().executorService().shutdownNow();
            }
        }
    }

    public boolean awaitClosed(long timeout2, TimeUnit timeUnit) throws InterruptedException {
        long timeoutMillis = EventSource.millisFromTimeUnit(timeout2, timeUnit);
        long deadline = System.currentTimeMillis() + timeoutMillis;
        if (!this.eventExecutor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
            return false;
        }
        long shutdownTimeoutMills = Math.max(0L, deadline - System.currentTimeMillis());
        if (!this.streamExecutor.awaitTermination(shutdownTimeoutMills, TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (this.client.dispatcher().executorService() != null) {
            shutdownTimeoutMills = Math.max(0L, deadline - System.currentTimeMillis());
            if (!this.client.dispatcher().executorService().awaitTermination(shutdownTimeoutMills, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        return true;
    }

    private void closeCurrentStream(ReadyState previousState) {
        if (previousState == ReadyState.OPEN) {
            this.handler.onClosed();
        }
        if (this.call != null) {
            this.call.cancel();
            this.logger.debug("call cancelled");
        }
    }

    Request buildRequest() {
        Request.Builder builder = new Request.Builder().headers(this.headers).url(this.url).method(this.method, this.body);
        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
            builder.addHeader("Last-Event-ID", this.lastEventId);
        }
        Request request = builder.build();
        return this.requestTransformer == null ? request : this.requestTransformer.transformRequest(request);
    }

    private void run() {
        AtomicLong connectedTime = new AtomicLong();
        int reconnectAttempts = 0;
        try {
            while (!Thread.currentThread().isInterrupted() && this.readyState.get() != ReadyState.SHUTDOWN) {
                reconnectAttempts = reconnectAttempts == 0 ? ++reconnectAttempts : this.maybeReconnectDelay(reconnectAttempts, connectedTime.get());
                this.newConnectionAttempt(connectedTime);
            }
        }
        catch (RejectedExecutionException ignored) {
            this.call = null;
            this.logger.debug("Rejected execution exception ignored: {}", (Object)ignored);
        }
    }

    private int maybeReconnectDelay(int reconnectAttempts, long connectedTime) {
        if (this.reconnectTimeMillis <= 0L) {
            return reconnectAttempts;
        }
        int counter = reconnectAttempts;
        if (connectedTime > 0L && System.currentTimeMillis() - connectedTime >= this.backoffResetThresholdMillis) {
            counter = 1;
        }
        try {
            long sleepTimeMillis = this.backoffWithJitterMillis(counter);
            this.logger.info("Waiting {} milliseconds before reconnecting...", (Object)sleepTimeMillis);
            Thread.sleep(sleepTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ++counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newConnectionAttempt(AtomicLong connectedTime) {
        ConnectionErrorHandler.Action errorHandlerAction = ConnectionErrorHandler.Action.PROCEED;
        ReadyState stateBeforeConnecting = this.readyState.getAndSet(ReadyState.CONNECTING);
        this.logger.debug("readyState change: {} -> {}", (Object)stateBeforeConnecting, (Object)ReadyState.CONNECTING);
        connectedTime.set(0L);
        this.call = this.client.newCall(this.buildRequest());
        try (Response response = this.call.execute();){
            if (response.isSuccessful()) {
                connectedTime.set(System.currentTimeMillis());
                this.handleSuccessfulResponse(response);
                ReadyState state = this.readyState.get();
                if (state != ReadyState.SHUTDOWN && state != ReadyState.CLOSED) {
                    this.logger.warn("Connection unexpectedly closed");
                    errorHandlerAction = this.connectionErrorHandler.onConnectionError(new EOFException());
                }
            } else {
                this.logger.debug("Unsuccessful response: {}", (Object)response);
                errorHandlerAction = this.dispatchError(new UnsuccessfulResponseException(response.code()));
            }
        }
        catch (IOException e) {
            ReadyState state = this.readyState.get();
            if (state != ReadyState.SHUTDOWN && state != ReadyState.CLOSED) {
                this.logger.debug("Connection problem: {}", (Object)e);
                errorHandlerAction = this.dispatchError(e);
            }
        }
        finally {
            if (errorHandlerAction == ConnectionErrorHandler.Action.SHUTDOWN) {
                this.logger.info("Connection has been explicitly shut down by error handler");
                this.close();
            } else {
                boolean wasOpen = this.readyState.compareAndSet(ReadyState.OPEN, ReadyState.CLOSED);
                boolean wasConnecting = this.readyState.compareAndSet(ReadyState.CONNECTING, ReadyState.CLOSED);
                if (wasOpen) {
                    this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.OPEN, (Object)ReadyState.CLOSED);
                    this.handler.onClosed();
                } else if (wasConnecting) {
                    this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.CONNECTING, (Object)ReadyState.CLOSED);
                }
            }
        }
    }

    private void handleSuccessfulResponse(Response response) throws IOException {
        ConnectionHandler connectionHandler = new ConnectionHandler(){

            @Override
            public void setReconnectTimeMillis(long reconnectTimeMillis) {
                EventSource.this.setReconnectTimeMillis(reconnectTimeMillis);
            }

            @Override
            public void setLastEventId(String lastEventId) {
                EventSource.this.setLastEventId(lastEventId);
            }
        };
        ReadyState previousState = this.readyState.getAndSet(ReadyState.OPEN);
        if (previousState != ReadyState.CONNECTING) {
            this.logger.warn("Unexpected readyState change: " + (Object)((Object)previousState) + " -> " + (Object)((Object)ReadyState.OPEN));
        } else {
            this.logger.debug("readyState change: {} -> {}", (Object)previousState, (Object)ReadyState.OPEN);
        }
        this.logger.info("Connected to EventSource stream.");
        this.handler.onOpen();
        EventParser parser = new EventParser(response.body().byteStream(), this.url.uri(), this.handler, connectionHandler, this.readBufferSize, this.streamEventData, this.expectFields, this.logger);
        while (!Thread.currentThread().isInterrupted() && !parser.isEof()) {
            parser.processStream();
        }
    }

    private ConnectionErrorHandler.Action dispatchError(Throwable t) {
        ConnectionErrorHandler.Action action = this.connectionErrorHandler.onConnectionError(t);
        if (action != ConnectionErrorHandler.Action.SHUTDOWN) {
            this.handler.onError(t);
        }
        return action;
    }

    long backoffWithJitterMillis(int reconnectAttempts) {
        long maxTimeLong = Math.min(this.maxReconnectTimeMillis, this.reconnectTimeMillis * (long)Helpers.pow2(reconnectAttempts));
        int maxTimeInt = maxTimeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxTimeLong;
        return maxTimeInt / 2 + this.jitter.nextInt(maxTimeInt) / 2;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        for (String name : defaultHeaders.names()) {
            if (custom.names().contains(name)) continue;
            for (String value : defaultHeaders.values(name)) {
                builder.add(name, value);
            }
        }
        for (String name : custom.names()) {
            for (String value : custom.values(name)) {
                builder.add(name, value);
            }
        }
        return builder.build();
    }

    private void setReconnectTimeMillis(long reconnectTimeMillis) {
        this.reconnectTimeMillis = reconnectTimeMillis;
    }

    private void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public HttpUrl getHttpUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.url.uri();
    }

    private static long millisFromTimeUnit(long duration, TimeUnit timeUnit) {
        return EventSource.timeUnitOrDefault(timeUnit).toMillis(duration);
    }

    private static TimeUnit timeUnitOrDefault(TimeUnit timeUnit) {
        return timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
    }

    public static final class Builder {
        private String name;
        private long reconnectTimeMillis = 1000L;
        private long maxReconnectTimeMillis = 30000L;
        private long backoffResetThresholdMillis = 60000L;
        private String lastEventId;
        private final HttpUrl url;
        private final EventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler = ConnectionErrorHandler.DEFAULT;
        private Integer threadPriority = null;
        private Headers headers = Headers.of(new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private String method = "GET";
        private RequestTransformer requestTransformer = null;
        private RequestBody body = null;
        private OkHttpClient.Builder clientBuilder;
        private int readBufferSize = 1000;
        private LDLogger logger = null;
        private int maxEventTasksInFlight = 0;
        private boolean streamEventData;
        private Set<String> expectFields = null;

        public Builder(EventHandler handler, URI uri) {
            this(handler, uri == null ? null : HttpUrl.get(uri));
        }

        public Builder(EventHandler handler, HttpUrl url) {
            if (handler == null) {
                throw new IllegalArgumentException("handler must not be null");
            }
            if (url == null) {
                throw new IllegalArgumentException("URI/URL must not be null");
            }
            this.url = url;
            this.handler = handler;
            this.clientBuilder = Builder.createInitialClientBuilder();
        }

        private static OkHttpClient.Builder createInitialClientBuilder() {
            OkHttpClient.Builder b = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).writeTimeout(5000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
            try {
                b.sslSocketFactory(new ModernTLSSocketFactory(), Builder.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return b;
        }

        public Builder method(String method) {
            this.method = method != null && method.length() > 0 ? method.toUpperCase() : "GET";
            return this;
        }

        public Builder body(RequestBody body) {
            this.body = body;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            this.requestTransformer = requestTransformer;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public Builder reconnectTime(long reconnectTime, TimeUnit timeUnit) {
            this.reconnectTimeMillis = EventSource.millisFromTimeUnit(reconnectTime, timeUnit);
            return this;
        }

        public Builder maxReconnectTime(long maxReconnectTime, TimeUnit timeUnit) {
            this.maxReconnectTimeMillis = EventSource.millisFromTimeUnit(maxReconnectTime, timeUnit);
            return this;
        }

        public Builder backoffResetThreshold(long backoffResetThreshold, TimeUnit timeUnit) {
            this.backoffResetThresholdMillis = EventSource.millisFromTimeUnit(backoffResetThreshold, timeUnit);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectTimeout(long connectTimeout, TimeUnit timeUnit) {
            this.clientBuilder.connectTimeout(connectTimeout, EventSource.timeUnitOrDefault(timeUnit));
            return this;
        }

        public Builder writeTimeout(long writeTimeout, TimeUnit timeUnit) {
            this.clientBuilder.writeTimeout(writeTimeout, EventSource.timeUnitOrDefault(timeUnit));
            return this;
        }

        public Builder readTimeout(long readTimeout, TimeUnit timeUnit) {
            this.clientBuilder.readTimeout(readTimeout, EventSource.timeUnitOrDefault(timeUnit));
            return this;
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            this.connectionErrorHandler = handler;
            return this;
        }

        public Builder threadPriority(Integer threadPriority) {
            this.threadPriority = threadPriority;
            return this;
        }

        public Builder clientBuilderActions(ClientConfigurer configurer) {
            configurer.configure(this.clientBuilder);
            return this;
        }

        public Builder readBufferSize(int readBufferSize) {
            if (readBufferSize <= 0) {
                throw new IllegalArgumentException("readBufferSize must be greater than zero");
            }
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder logger(LDLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder maxEventTasksInFlight(int maxEventTasksInFlight) {
            this.maxEventTasksInFlight = maxEventTasksInFlight;
            return this;
        }

        public Builder streamEventData(boolean streamEventData) {
            this.streamEventData = streamEventData;
            return this;
        }

        public Builder expectFields(String ... fieldNames) {
            if (fieldNames == null || fieldNames.length == 0) {
                this.expectFields = null;
            } else {
                this.expectFields = new HashSet<String>();
                for (String f : fieldNames) {
                    if (f == null) continue;
                    this.expectFields.add(f);
                }
            }
            return this;
        }

        public EventSource build() {
            if (this.proxy != null) {
                this.clientBuilder.proxy(this.proxy);
            }
            if (this.proxyAuthenticator != null) {
                this.clientBuilder.proxyAuthenticator(this.proxyAuthenticator);
            }
            return new EventSource(this);
        }

        protected OkHttpClient.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }

        public static interface ClientConfigurer {
            public void configure(OkHttpClient.Builder var1);
        }
    }

    public static interface RequestTransformer {
        public Request transformRequest(Request var1);
    }
}

