/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Objects;

public class MessageEvent {
    public static final String DEFAULT_EVENT_NAME = "message";
    private static final int READER_BUFFER_SIZE = 2000;
    private volatile String data;
    private volatile Reader dataReader;
    private final Object dataReaderLock;
    private final String eventName;
    private final String lastEventId;
    private final URI origin;

    public MessageEvent(String data) {
        this(null, data, null, null);
    }

    public MessageEvent(String data, String lastEventId, URI origin) {
        this(null, data, lastEventId, origin);
    }

    public MessageEvent(String eventName, String data, String lastEventId, URI origin) {
        this.eventName = eventName == null ? DEFAULT_EVENT_NAME : eventName;
        this.data = data == null ? "" : data;
        this.dataReader = null;
        this.dataReaderLock = new Object();
        this.lastEventId = lastEventId;
        this.origin = origin;
    }

    public MessageEvent(String eventName, Reader dataReader, String lastEventId, URI origin) {
        this.data = null;
        this.dataReader = dataReader;
        this.dataReaderLock = new Object();
        this.eventName = eventName == null ? DEFAULT_EVENT_NAME : eventName;
        this.lastEventId = lastEventId;
        this.origin = origin;
    }

    public MessageEvent(String eventName, String data) {
        this(eventName, data, null, null);
    }

    public String getEventName() {
        return this.eventName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        if (this.data != null) {
            return this.data;
        }
        Object object = this.dataReaderLock;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            char[] buffer = new char[2000];
            StringBuilder sb = new StringBuilder(2000);
            try {
                int n;
                while ((n = this.dataReader.read(buffer, 0, buffer.length)) != -1) {
                    sb.append(buffer, 0, n);
                }
                this.dataReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = sb.toString();
            this.dataReader = new StringReader(this.data);
            return this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getDataReader() {
        Object object = this.dataReaderLock;
        synchronized (object) {
            if (this.dataReader == null) {
                this.dataReader = new StringReader(this.data);
            }
            return this.dataReader;
        }
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public URI getOrigin() {
        return this.origin;
    }

    public boolean isStreamingData() {
        return this.data == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.dataReaderLock;
        synchronized (object) {
            if (this.dataReader != null) {
                try {
                    this.dataReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEvent that = (MessageEvent)o;
        return Objects.equals(this.getEventName(), that.getEventName()) && Objects.equals(this.getData(), that.getData()) && Objects.equals(this.getLastEventId(), that.getLastEventId()) && Objects.equals(this.getOrigin(), that.getOrigin());
    }

    public int hashCode() {
        return Objects.hash(this.getEventName(), this.getData(), this.getLastEventId(), this.getOrigin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.dataReaderLock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder("MessageEvent(eventName=").append(this.eventName).append(",data=").append(this.data == null ? "<streaming>" : this.data);
            if (this.lastEventId != null) {
                sb.append(",id=").append(this.lastEventId);
            }
            sb.append(",origin=").append(this.origin).append(')');
            return sb.toString();
        }
    }
}

