/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;

public class Event {
    private final long creationDate;
    private final LDContext context;

    public Event(long creationDate, LDContext context) {
        this.creationDate = creationDate;
        this.context = context;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public LDContext getContext() {
        return this.context;
    }

    public static final class FeatureRequest
    extends Event {
        private final String key;
        private final int variation;
        private final LDValue value;
        private final LDValue defaultVal;
        private final int version;
        private final String prereqOf;
        private final boolean trackEvents;
        private final Long debugEventsUntilDate;
        private final EvaluationReason reason;
        private final boolean debug;

        public FeatureRequest(long timestamp, String key, LDContext context, int version, int variation, LDValue value, LDValue defaultVal, EvaluationReason reason, String prereqOf, boolean trackEvents, Long debugEventsUntilDate, boolean debug) {
            super(timestamp, context);
            this.key = key;
            this.version = version;
            this.variation = variation;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
            this.trackEvents = trackEvents;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.reason = reason;
            this.debug = debug;
        }

        public String getKey() {
            return this.key;
        }

        public int getVariation() {
            return this.variation;
        }

        public LDValue getValue() {
            return this.value;
        }

        public LDValue getDefaultVal() {
            return this.defaultVal;
        }

        public int getVersion() {
            return this.version;
        }

        public String getPrereqOf() {
            return this.prereqOf;
        }

        public boolean isTrackEvents() {
            return this.trackEvents;
        }

        public Long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        public EvaluationReason getReason() {
            return this.reason;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public FeatureRequest toDebugEvent() {
            return new FeatureRequest(this.getCreationDate(), this.getKey(), this.getContext(), this.getVersion(), this.getVariation(), this.getValue(), this.getDefaultVal(), this.getReason(), this.getPrereqOf(), false, null, true);
        }
    }

    public static final class Index
    extends Event {
        public Index(long timestamp, LDContext context) {
            super(timestamp, context);
        }
    }

    public static final class Identify
    extends Event {
        public Identify(long timestamp, LDContext context) {
            super(timestamp, context);
        }
    }

    public static final class Custom
    extends Event {
        private final String key;
        private final LDValue data;
        private final Double metricValue;

        public Custom(long timestamp, String key, LDContext context, LDValue data, Double metricValue) {
            super(timestamp, context);
            this.key = key;
            this.data = LDValue.normalize(data);
            this.metricValue = metricValue;
        }

        public String getKey() {
            return this.key;
        }

        public LDValue getData() {
            return this.data;
        }

        public Double getMetricValue() {
            return this.metricValue;
        }
    }
}

