/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.LDUserTypeAdapter;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Deprecated
@JsonAdapter(value=LDUserTypeAdapter.class)
public class LDUser
implements JsonSerializable {
    final LDValue key;
    final LDValue ip;
    final LDValue email;
    final LDValue name;
    final LDValue avatar;
    final LDValue firstName;
    final LDValue lastName;
    final boolean anonymous;
    final LDValue country;
    final Map<UserAttribute, LDValue> custom;
    Set<UserAttribute> privateAttributeNames;

    protected LDUser(Builder builder) {
        this.key = LDValue.of(builder.key);
        this.ip = LDValue.of(builder.ip);
        this.country = LDValue.of(builder.country);
        this.firstName = LDValue.of(builder.firstName);
        this.lastName = LDValue.of(builder.lastName);
        this.email = LDValue.of(builder.email);
        this.name = LDValue.of(builder.name);
        this.avatar = LDValue.of(builder.avatar);
        this.anonymous = builder.anonymous;
        this.custom = builder.custom == null ? null : Collections.unmodifiableMap(builder.custom);
        this.privateAttributeNames = builder.privateAttributes == null ? null : Collections.unmodifiableSet(builder.privateAttributes);
    }

    public LDUser(String key) {
        this.key = LDValue.of(key);
        this.lastName = this.country = LDValue.ofNull();
        this.firstName = this.country;
        this.avatar = this.country;
        this.name = this.country;
        this.email = this.country;
        this.ip = this.country;
        this.anonymous = false;
        this.custom = null;
        this.privateAttributeNames = null;
    }

    public String getKey() {
        return this.key.stringValue();
    }

    public String getIp() {
        return this.ip.stringValue();
    }

    public String getCountry() {
        return this.country.stringValue();
    }

    public String getName() {
        return this.name.stringValue();
    }

    public String getFirstName() {
        return this.firstName.stringValue();
    }

    public String getLastName() {
        return this.lastName.stringValue();
    }

    public String getEmail() {
        return this.email.stringValue();
    }

    public String getAvatar() {
        return this.avatar.stringValue();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public LDValue getAttribute(UserAttribute attribute) {
        if (attribute.isBuiltIn()) {
            return attribute.builtInGetter.apply(this);
        }
        return this.custom == null ? LDValue.ofNull() : LDValue.normalize(this.custom.get(attribute));
    }

    public Iterable<UserAttribute> getCustomAttributes() {
        return this.custom == null ? Collections.emptyList() : this.custom.keySet();
    }

    public Iterable<UserAttribute> getPrivateAttributes() {
        return this.privateAttributeNames == null ? Collections.emptyList() : this.privateAttributeNames;
    }

    public boolean isAttributePrivate(UserAttribute attribute) {
        return this.privateAttributeNames != null && this.privateAttributeNames.contains(attribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LDUser) {
            LDUser ldUser = (LDUser)o;
            return Objects.equals(this.key, ldUser.key) && Objects.equals(this.ip, ldUser.ip) && Objects.equals(this.email, ldUser.email) && Objects.equals(this.name, ldUser.name) && Objects.equals(this.avatar, ldUser.avatar) && Objects.equals(this.firstName, ldUser.firstName) && Objects.equals(this.lastName, ldUser.lastName) && Objects.equals(this.country, ldUser.country) && this.anonymous == ldUser.anonymous && Objects.equals(this.custom, ldUser.custom) && Objects.equals(this.privateAttributeNames, ldUser.privateAttributeNames);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.ip, this.email, this.name, this.avatar, this.firstName, this.lastName, this.anonymous, this.country, this.custom, this.privateAttributeNames);
    }

    public String toString() {
        return "LDUser(" + JsonSerialization.serialize(this) + ")";
    }

    @Deprecated
    public static class Builder {
        private String key;
        private String ip;
        private String firstName;
        private String lastName;
        private String email;
        private String name;
        private String avatar;
        private String country;
        private boolean anonymous = false;
        private Map<UserAttribute, LDValue> custom;
        private Set<UserAttribute> privateAttributes;

        public Builder(String key) {
            this.key = key;
        }

        public Builder(LDUser user) {
            this.key = user.key.stringValue();
            this.ip = user.ip.stringValue();
            this.firstName = user.firstName.stringValue();
            this.lastName = user.lastName.stringValue();
            this.email = user.email.stringValue();
            this.name = user.name.stringValue();
            this.avatar = user.avatar.stringValue();
            this.anonymous = user.anonymous;
            this.country = user.country.stringValue();
            this.custom = user.custom == null ? null : new HashMap<UserAttribute, LDValue>(user.custom);
            this.privateAttributes = user.privateAttributeNames == null ? null : new HashSet<UserAttribute>(user.privateAttributeNames);
        }

        public Builder key(String s2) {
            this.key = s2;
            return this;
        }

        public Builder ip(String s2) {
            this.ip = s2;
            return this;
        }

        public Builder privateIp(String s2) {
            this.addPrivate(UserAttribute.IP);
            return this.ip(s2);
        }

        public Builder country(String s2) {
            this.country = s2;
            return this;
        }

        public Builder privateCountry(String s2) {
            this.addPrivate(UserAttribute.COUNTRY);
            return this.country(s2);
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder privateFirstName(String firstName) {
            this.addPrivate(UserAttribute.FIRST_NAME);
            return this.firstName(firstName);
        }

        public Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder privateLastName(String lastName) {
            this.addPrivate(UserAttribute.LAST_NAME);
            return this.lastName(lastName);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privateName(String name) {
            this.addPrivate(UserAttribute.NAME);
            return this.name(name);
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder privateAvatar(String avatar) {
            this.addPrivate(UserAttribute.AVATAR);
            return this.avatar(avatar);
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder privateEmail(String email) {
            this.addPrivate(UserAttribute.EMAIL);
            return this.email(email);
        }

        public Builder custom(String k, String v) {
            return this.custom(k, LDValue.of(v));
        }

        public Builder custom(String k, int n) {
            return this.custom(k, LDValue.of(n));
        }

        public Builder custom(String k, double n) {
            return this.custom(k, LDValue.of(n));
        }

        public Builder custom(String k, boolean b) {
            return this.custom(k, LDValue.of(b));
        }

        public Builder custom(String k, LDValue v) {
            if (k != null) {
                return this.customInternal(UserAttribute.forName(k), v);
            }
            return this;
        }

        private Builder customInternal(UserAttribute a, LDValue v) {
            if (this.custom == null) {
                this.custom = new HashMap<UserAttribute, LDValue>();
            }
            this.custom.put(a, LDValue.normalize(v));
            return this;
        }

        public Builder privateCustom(String k, String v) {
            return this.privateCustom(k, LDValue.of(v));
        }

        public Builder privateCustom(String k, int n) {
            return this.privateCustom(k, LDValue.of(n));
        }

        public Builder privateCustom(String k, double n) {
            return this.privateCustom(k, LDValue.of(n));
        }

        public Builder privateCustom(String k, boolean b) {
            return this.privateCustom(k, LDValue.of(b));
        }

        public Builder privateCustom(String k, LDValue v) {
            if (k != null) {
                UserAttribute a = UserAttribute.forName(k);
                this.addPrivate(a);
                return this.customInternal(a, v);
            }
            return this;
        }

        void addPrivate(UserAttribute attribute) {
            if (this.privateAttributes == null) {
                this.privateAttributes = new LinkedHashSet<UserAttribute>();
            }
            this.privateAttributes.add(attribute);
        }

        public LDUser build() {
            return new LDUser(this);
        }
    }
}

