/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvalResultAndFlag;
import com.launchdarkly.sdk.server.EvaluationOptions;
import com.launchdarkly.sdk.server.EvaluatorInterface;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.MigrationStage;

class MigrationStageEnforcingEvaluator
implements EvaluatorInterface {
    private final EvaluatorInterface underlyingEvaluator;
    private final LDLogger logger;

    MigrationStageEnforcingEvaluator(EvaluatorInterface underlyingEvaluator, LDLogger logger) {
        this.underlyingEvaluator = underlyingEvaluator;
        this.logger = logger;
    }

    @Override
    public EvalResultAndFlag evalAndFlag(String method, String flagKey, LDContext context, LDValue defaultValue, LDValueType requireType, EvaluationOptions options) {
        EvalResultAndFlag res = this.underlyingEvaluator.evalAndFlag(method, flagKey, context, defaultValue, requireType, options);
        EvaluationDetail<String> resDetail = res.getResult().getAsString();
        String resStageString = resDetail.getValue();
        if (!MigrationStage.isStage(resStageString)) {
            this.logger.error("Unrecognized MigrationState for \"{}\"; returning default value.", (Object)flagKey);
            return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.WRONG_TYPE, defaultValue), res.getFlag());
        }
        return res;
    }

    @Override
    public FeatureFlagsState allFlagsState(LDContext context, FlagsStateOption ... options) {
        return this.underlyingEvaluator.allFlagsState(context, options);
    }
}

