/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.time.Duration;

public abstract class PersistentDataStoreBuilder
implements ComponentConfigurer<DataStore> {
    public static final Duration DEFAULT_CACHE_TTL = Duration.ofSeconds(15L);
    protected final ComponentConfigurer<PersistentDataStore> persistentDataStoreConfigurer;
    protected Duration cacheTime = DEFAULT_CACHE_TTL;
    protected StaleValuesPolicy staleValuesPolicy = StaleValuesPolicy.EVICT;
    protected boolean recordCacheStats = false;

    protected PersistentDataStoreBuilder(ComponentConfigurer<PersistentDataStore> persistentDataStoreConfigurer) {
        this.persistentDataStoreConfigurer = persistentDataStoreConfigurer;
    }

    public PersistentDataStoreBuilder noCaching() {
        return this.cacheTime(Duration.ZERO);
    }

    public PersistentDataStoreBuilder cacheTime(Duration cacheTime) {
        this.cacheTime = cacheTime == null ? DEFAULT_CACHE_TTL : cacheTime;
        return this;
    }

    public PersistentDataStoreBuilder cacheMillis(long millis) {
        return this.cacheTime(Duration.ofMillis(millis));
    }

    public PersistentDataStoreBuilder cacheSeconds(long seconds) {
        return this.cacheTime(Duration.ofSeconds(seconds));
    }

    public PersistentDataStoreBuilder cacheForever() {
        return this.cacheTime(Duration.ofMillis(-1L));
    }

    public PersistentDataStoreBuilder staleValuesPolicy(StaleValuesPolicy staleValuesPolicy) {
        this.staleValuesPolicy = staleValuesPolicy == null ? StaleValuesPolicy.EVICT : staleValuesPolicy;
        return this;
    }

    public PersistentDataStoreBuilder recordCacheStats(boolean recordCacheStats) {
        this.recordCacheStats = recordCacheStats;
        return this;
    }

    public static enum StaleValuesPolicy {
        EVICT,
        REFRESH,
        REFRESH_ASYNC;

    }
}

