/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.host;

import java.io.UnsupportedEncodingException;

public class HostContext {
    private static final String DEFAULT_CHARSET_NAME = "IBM01140";
    private static final String INTEGER_SIGNS = "0123456789\u0000 +-";
    private String mhostCharsetName = HostContext.getDefaultHostCharsetName();
    private byte[] hostIntegerSigns = HostContext.getHostIntegerSigns(HostContext.getDefaultHostCharsetName());

    public String getHostCharsetName() {
        return this.mhostCharsetName;
    }

    public void setHostCharsetName(String charsetName) {
        if (charsetName == null || charsetName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid host character set");
        }
        this.mhostCharsetName = charsetName;
        this.hostIntegerSigns = HostContext.getHostIntegerSigns(charsetName);
    }

    public static String getDefaultHostCharsetName() {
        return DEFAULT_CHARSET_NAME;
    }

    public byte[] getHostIntegerSigns() {
        return this.hostIntegerSigns;
    }

    public static byte[] getHostIntegerSigns(String charsetName) {
        try {
            return INTEGER_SIGNS.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getIntegerSigns() {
        return INTEGER_SIGNS;
    }
}

