/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.host;

public class HostData {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private final byte[] mhostData;

    public HostData(byte[] hostData) {
        this.mhostData = hostData;
    }

    public HostData(String hexString) {
        this.mhostData = HostData.toByteArray(hexString);
    }

    public String toHexString() {
        return HostData.toHexString(this.mhostData);
    }

    public static String toHexString(byte[] hostBytes) {
        if (hostBytes == null) {
            return null;
        }
        return HostData.toHexString(hostBytes, 0, hostBytes.length);
    }

    public static String toHexString(byte[] hostBytes, int start, int length) {
        if (hostBytes == null) {
            return null;
        }
        if (start + length > hostBytes.length) {
            throw new IllegalArgumentException("Invalid start or length parameter");
        }
        char[] chars = new char[2 * length];
        for (int i = 0; i < length; ++i) {
            chars[2 * i] = HEX_CHARS[(hostBytes[i + start] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[hostBytes[i + start] & 0xF];
        }
        return new String(chars);
    }

    public static String toHexString(byte[] hostBytes, int maxBytes) {
        if (hostBytes == null) {
            return null;
        }
        return HostData.toHexString(hostBytes, 0, hostBytes.length, maxBytes);
    }

    public static String toHexString(byte[] hostBytes, int start, int length, int maxBytes) {
        int i;
        if (hostBytes == null) {
            return null;
        }
        if (start + length > hostBytes.length) {
            throw new IllegalArgumentException("Invalid start or length parameter");
        }
        if (length <= maxBytes) {
            return HostData.toHexString(hostBytes, start, length);
        }
        if (maxBytes < 2) {
            throw new IllegalArgumentException("maxBytes cannot be smaller than 2");
        }
        int gap = maxBytes / 2;
        StringBuffer hexString = new StringBuffer("");
        for (i = start; i < start + gap; ++i) {
            hexString.append(Integer.toHexString(hostBytes[i] & 0xFF | 0x100).substring(1, 3));
        }
        hexString.append("....");
        for (i = start + length - gap; i < start + length; ++i) {
            hexString.append(Integer.toHexString(hostBytes[i] & 0xFF | 0x100).substring(1, 3));
        }
        return hexString.toString();
    }

    public static byte[] toByteArray(String string) {
        if (string == null) {
            return new byte[0];
        }
        byte[] hostBytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            hostBytes[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return hostBytes;
    }

    public byte[] getHostData() {
        return this.mhostData;
    }

    public int length() {
        return this.mhostData.length;
    }
}

