/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IHostToJavaTransformer;
import com.legstar.coxb.transform.IHostToJsonTransformer;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public abstract class AbstractHostToJsonTransformer
implements IHostToJsonTransformer {
    private final Log _log = LogFactory.getLog(AbstractHostToJsonTransformer.class);
    private IHostToJavaTransformer _hostToJavaTransformer;
    private ObjectMapper _jsonMapper;

    public AbstractHostToJsonTransformer(IHostToJavaTransformer hostToJavaTransformer) throws HostTransformException {
        this._hostToJavaTransformer = hostToJavaTransformer;
        this._jsonMapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this._jsonMapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this._jsonMapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public void transform(byte[] hostData, int offset, Writer writer, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Transforming host data to JSON:");
        }
        Object valueObject = this.getHostToJavaTransformer().transform(hostData, offset, hostCharset, status);
        this.getJsonFromObject(valueObject, writer);
    }

    public void transform(byte[] hostData, int offset, Writer writer, String hostCharset) throws HostTransformException {
        this.transform(hostData, offset, writer, hostCharset, new HostTransformStatus());
    }

    public void transform(byte[] hostData, Writer writer, String hostCharset) throws HostTransformException {
        this.transform(hostData, 0, writer, hostCharset);
    }

    public void transform(byte[] hostData, Writer writer) throws HostTransformException {
        this.transform(hostData, 0, writer, (String)null);
    }

    public void transform(byte[] hostData, int offset, Writer writer) throws HostTransformException {
        this.transform(hostData, offset, writer, (String)null);
    }

    public void transform(byte[] hostData, Writer writer, String hostCharset, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, 0, writer, hostCharset, status);
    }

    public void transform(byte[] hostData, Writer writer, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, 0, writer, null, status);
    }

    public void transform(byte[] hostData, int offset, Writer writer, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, offset, writer, null, status);
    }

    public void getJsonFromObject(Object valueObject, Writer writer) throws HostTransformException {
        try {
            this._jsonMapper.writeValue(writer, valueObject);
        }
        catch (JsonGenerationException e) {
            throw new HostTransformException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new HostTransformException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new HostTransformException(e);
        }
    }

    public IHostToJavaTransformer getHostToJavaTransformer() {
        return this._hostToJavaTransformer;
    }
}

