/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.util;

import com.legstar.coxb.util.ClassInvokeException;
import com.legstar.coxb.util.ClassLoadingException;
import com.legstar.coxb.util.ClassMethodException;
import com.legstar.coxb.util.NameUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private ClassUtil() {
    }

    public static Class<?> loadClass(String packageName, String className) throws ClassNotFoundException {
        return ClassUtil.loadClass(ClassUtil.toQualifiedClassName(packageName, className));
    }

    public static Class<?> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            return Class.forName(qualifiedClassName);
        }
        try {
            return contextClassLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(qualifiedClassName);
        }
    }

    public static Object newObject(String packageName, String className) throws ClassLoadingException {
        return ClassUtil.newObject(ClassUtil.toQualifiedClassName(packageName, className));
    }

    public static Object newObject(String qualifiedClassName) throws ClassLoadingException {
        try {
            Class<?> clazz = ClassUtil.loadClass(qualifiedClassName);
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ClassLoadingException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClassLoadingException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoadingException(e);
        }
    }

    public static String toQualifiedClassName(String packageName, String className) {
        return packageName == null ? className : packageName + '.' + className;
    }

    public static ClassName toClassName(String qualifiedClassName) {
        ClassName className = new ClassName();
        int pos = qualifiedClassName.lastIndexOf(46);
        className.packageName = pos == -1 ? null : qualifiedClassName.substring(0, pos);
        className.className = pos == -1 ? qualifiedClassName : qualifiedClassName.substring(pos + 1);
        return className;
    }

    public static Method getCreatorMethod(Object objectFactory, String jaxbTypeName) throws ClassMethodException {
        try {
            Method creator = objectFactory.getClass().getMethod("create" + ClassUtil.toPropertyType(jaxbTypeName), new Class[0]);
            return creator;
        }
        catch (NoSuchMethodException e) {
            throw new ClassMethodException(e);
        }
    }

    public static Method getGetterMethod(Object parentObject, String getterPrefix, String jaxbName) throws ClassMethodException {
        String getterName = ClassUtil.getGetterName(getterPrefix, jaxbName);
        try {
            Method getter = parentObject.getClass().getMethod(getterName, new Class[0]);
            return getter;
        }
        catch (NoSuchMethodException e) {
            throw new ClassMethodException(e);
        }
    }

    public static String getGetterName(String getterPrefix, String fieldName) {
        return getterPrefix + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static Method getSetterMethod(Object parentObject, String jaxbName, Class<?> jaxbType) throws ClassMethodException {
        String setterName = ClassUtil.getSetterMethodName(jaxbName);
        try {
            Class[] param = new Class[]{jaxbType};
            Method setter = parentObject.getClass().getMethod(setterName, param);
            return setter;
        }
        catch (NoSuchMethodException e) {
            throw new ClassMethodException(e);
        }
    }

    public static String getSetterMethodName(String jaxbName) {
        return "set" + NameUtil.upperFirstChar(jaxbName) + jaxbName.substring(1);
    }

    public static String toPropertyType(String genericType) {
        String type;
        int lp = genericType.lastIndexOf(46);
        if (lp == -1) {
            type = genericType;
        } else {
            type = genericType.substring(lp + 1);
            if (type.charAt(type.length() - 1) == '>') {
                type = type.substring(0, type.length() - 1);
            }
        }
        if (type.compareTo("byte") == 0) {
            return "Byte";
        }
        if (type.compareTo("[B") == 0) {
            return "byte[]";
        }
        if (type.compareTo("short") == 0) {
            return "Short";
        }
        if (type.compareTo("int") == 0) {
            return "Integer";
        }
        if (type.compareTo("long") == 0) {
            return "Long";
        }
        if (type.compareTo("float") == 0) {
            return "Float";
        }
        if (type.compareTo("double") == 0) {
            return "Double";
        }
        if (type.compareTo("boolean") == 0) {
            return "Boolean";
        }
        return type;
    }

    public static Object invokeGetProperty(Object parentObject, String jaxbName) throws ClassInvokeException {
        Object result;
        try {
            Method getter = ClassUtil.getGetterMethod(parentObject, "get", jaxbName);
            result = getter.invoke(parentObject, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
        catch (ClassMethodException e) {
            throw new ClassInvokeException(e);
        }
        return result;
    }

    public static Object invokeGetProperty(Object parentObject, String jaxbName, Class<?> jaxbType, int maxOccurs) throws ClassInvokeException {
        Object result;
        try {
            Method getter = ClassUtil.getGetterMethod(parentObject, ClassUtil.getGetterPrefix(jaxbType, maxOccurs), jaxbName);
            result = getter.invoke(parentObject, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
        catch (ClassMethodException e) {
            throw new ClassInvokeException(e);
        }
        return result;
    }

    public static String getGetterPrefix(Class<?> fieldType, int maxOccurs) {
        String getterPrefix = "get";
        if (maxOccurs <= 1) {
            if (fieldType == Boolean.TYPE) {
                getterPrefix = "is";
            } else if (fieldType == Boolean.class) {
                getterPrefix = "is";
            }
        }
        return getterPrefix;
    }

    public static void invokeSetProperty(Object parentObject, String jaxbName, Object value, Class<?> javaType) throws ClassInvokeException {
        try {
            if (value instanceof List) {
                Method getter = ClassUtil.getGetterMethod(parentObject, "get", jaxbName);
                Class<?> listClass = getter.getReturnType();
                Method addAll = listClass.getMethod("addAll", Collection.class);
                addAll.invoke(getter.invoke(parentObject, new Object[0]), (Collection)value);
            } else {
                Method setter = ClassUtil.getSetterMethod(parentObject, jaxbName, javaType);
                setter.invoke(parentObject, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
        catch (ClassMethodException e) {
            throw new ClassInvokeException(e);
        }
    }

    public static Object addComplexProperty(Object objectFactory, Object parentObject, String jaxbName, String jaxbTypeName) throws ClassInvokeException {
        try {
            Method creator = ClassUtil.getCreatorMethod(objectFactory, jaxbTypeName);
            Object result = creator.invoke(objectFactory, new Object[0]);
            Method setter = ClassUtil.getSetterMethod(parentObject, jaxbName, creator.getReturnType());
            setter.invoke(parentObject, result);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
        catch (ClassMethodException e) {
            throw new ClassInvokeException(e);
        }
    }

    public static Object invokeGetIndexedProperty(Object parentObject, int index) throws ClassInvokeException {
        Object result;
        try {
            Method getter = parentObject.getClass().getMethod("get", Integer.TYPE);
            result = getter.invoke(parentObject, index);
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException().getClass().getName().compareTo("java.lang.IndexOutOfBoundsException") == 0) {
                return null;
            }
            throw new ClassInvokeException(e);
        }
        return result;
    }

    public static Object addComplexIndexedProperty(Object objectFactory, Object parentObject, String jaxbTypeName, int index) throws ClassInvokeException {
        try {
            Method creator = ClassUtil.getCreatorMethod(objectFactory, jaxbTypeName);
            Object result = creator.invoke(objectFactory, new Object[0]);
            Class[] param = new Class[]{Integer.TYPE, Object.class};
            Method add = parentObject.getClass().getMethod("add", param);
            add.invoke(parentObject, index, result);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
        catch (ClassMethodException e) {
            throw new ClassInvokeException(e);
        }
    }

    public static void addSimpleIndexedProperty(Object parentObject, int index, Object value) throws ClassInvokeException {
        try {
            Class[] param = new Class[]{Integer.TYPE, Object.class};
            Method setter = parentObject.getClass().getMethod("add", param);
            setter.invoke(parentObject, index, value);
        }
        catch (IllegalAccessException e) {
            throw new ClassInvokeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInvokeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassInvokeException(e);
        }
    }

    public static boolean isEnum(String type) {
        if (type == null) {
            return false;
        }
        if (type.compareToIgnoreCase("String") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("[B") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("byte[]") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("short") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("int") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("Integer") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("long") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("float") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("double") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("BigInteger") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("BigDecimal") == 0) {
            return false;
        }
        if (type.compareToIgnoreCase("byte") == 0) {
            return false;
        }
        return type.compareToIgnoreCase("boolean") != 0;
    }

    public static class ClassName {
        public String className;
        public String packageName;
    }
}

