/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb;

import com.legstar.coxb.ICobolArrayBinaryBinding;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolArrayDbcsBinding;
import com.legstar.coxb.ICobolArrayDoubleBinding;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolArrayNationalBinding;
import com.legstar.coxb.ICobolArrayOctetStreamBinding;
import com.legstar.coxb.ICobolArrayPackedDecimalBinding;
import com.legstar.coxb.ICobolArrayStringBinding;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolDbcsBinding;
import com.legstar.coxb.ICobolDoubleBinding;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.ICobolNationalBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.ICobolPackedDecimalBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.ICobolConverters;
import com.legstar.coxb.host.HostException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CobolElementVisitor {
    private byte[] mHostBytes;
    private int mOffset;
    private ICobolConverters mCobolConverters;
    private Hashtable<String, Object> mVariablesMap;
    private final Log _log = LogFactory.getLog(CobolElementVisitor.class);

    public CobolElementVisitor() {
        this.mHostBytes = null;
        this.mOffset = 0;
        this.mCobolConverters = null;
        this.mVariablesMap = new Hashtable();
    }

    public CobolElementVisitor(byte[] hostBytes, int offset, ICobolConverters cobolConverters) {
        this.mHostBytes = hostBytes;
        this.mOffset = offset;
        this.mCobolConverters = cobolConverters;
        this.mVariablesMap = new Hashtable();
    }

    public abstract void visit(ICobolComplexBinding var1) throws HostException;

    public abstract void visit(ICobolChoiceBinding var1) throws HostException;

    public abstract void visit(ICobolArrayComplexBinding var1) throws HostException;

    public abstract void visit(ICobolStringBinding var1) throws HostException;

    public abstract void visit(ICobolArrayStringBinding var1) throws HostException;

    public abstract void visit(ICobolNationalBinding var1) throws HostException;

    public abstract void visit(ICobolArrayNationalBinding var1) throws HostException;

    public abstract void visit(ICobolDbcsBinding var1) throws HostException;

    public abstract void visit(ICobolArrayDbcsBinding var1) throws HostException;

    public abstract void visit(ICobolZonedDecimalBinding var1) throws HostException;

    public abstract void visit(ICobolArrayZonedDecimalBinding var1) throws HostException;

    public abstract void visit(ICobolPackedDecimalBinding var1) throws HostException;

    public abstract void visit(ICobolArrayPackedDecimalBinding var1) throws HostException;

    public abstract void visit(ICobolBinaryBinding var1) throws HostException;

    public abstract void visit(ICobolArrayBinaryBinding var1) throws HostException;

    public abstract void visit(ICobolFloatBinding var1) throws HostException;

    public abstract void visit(ICobolArrayFloatBinding var1) throws HostException;

    public abstract void visit(ICobolDoubleBinding var1) throws HostException;

    public abstract void visit(ICobolArrayDoubleBinding var1) throws HostException;

    public abstract void visit(ICobolOctetStreamBinding var1) throws HostException;

    public abstract void visit(ICobolArrayOctetStreamBinding var1) throws HostException;

    public ICobolConverters getCobolConverters() {
        return this.mCobolConverters;
    }

    public void setCobolConverters(ICobolConverters cobolConverters) {
        this.mCobolConverters = cobolConverters;
    }

    public byte[] getHostBytes() {
        return this.mHostBytes;
    }

    public void setHostBytes(byte[] hostBytes) {
        this.mHostBytes = hostBytes;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public Hashtable<String, Object> getVariablesMap() {
        return this.mVariablesMap;
    }

    public void setVariablesMap(Hashtable<String, Object> variablesMap) {
        this.mVariablesMap = variablesMap;
    }

    public void storeCustomVariable(ICobolBinding binding) throws HostException {
        this.getVariablesMap().put(binding.getBindingName(), binding.getObjectValue(binding.getJaxbType()));
    }

    public boolean exists(ICobolBinding ce) throws HostException {
        if (ce.getDependingOn() != null && ce.getDependingOn().length() > 0 && ce.getParentBinding().getCounterValue(ce.getDependingOn()) == 0) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Visiting aborted for binding " + ce.getBindingName() + ", it depends on " + ce.getDependingOn() + " which is zero"));
            }
            return false;
        }
        return true;
    }
}

