/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.transform.AbstractTransformer;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IHostToJavaTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHostToJavaTransformer
extends AbstractTransformer
implements IHostToJavaTransformer {
    private final Log _log = LogFactory.getLog(AbstractHostToJavaTransformer.class);

    public AbstractHostToJavaTransformer() {
    }

    public AbstractHostToJavaTransformer(String hostCharset) {
        super(hostCharset);
    }

    public AbstractHostToJavaTransformer(CobolContext cobolContext) {
        super(cobolContext);
    }

    @Override
    public <T> T transform(byte[] hostData) throws HostTransformException {
        return this.transform(hostData, 0);
    }

    @Override
    public <T> T transform(byte[] hostData, int offset) throws HostTransformException {
        return this.transform(hostData, offset, (String)null);
    }

    @Override
    public <T> T transform(byte[] hostData, String hostCharset) throws HostTransformException {
        return this.transform(hostData, 0, hostCharset);
    }

    @Override
    public <T> T transform(byte[] hostData, int offset, String hostCharset) throws HostTransformException {
        return this.transform(hostData, offset, hostCharset, new HostTransformStatus());
    }

    @Override
    public <T> T transform(byte[] hostData, String hostCharset, HostTransformStatus status) throws HostTransformException {
        return this.transform(hostData, 0, hostCharset, status);
    }

    @Override
    public <T> T transform(byte[] hostData, int offset, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (hostCharset != null && hostCharset.length() > 0) {
            this.getCobolConverters().getCobolContext().setHostCharsetName(hostCharset);
        }
        return this.transform(hostData, offset, status);
    }

    @Override
    public <T> T transform(byte[] hostData, HostTransformStatus status) throws HostTransformException {
        return this.transform(hostData, 0, status);
    }

    @Override
    public <T> T transform(byte[] hostData, int offset, HostTransformStatus status) throws HostTransformException {
        long start = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Host to Java transformation started");
        }
        if (hostData == null) {
            throw new HostTransformException("Host data is null. Unable to transform to java.");
        }
        try {
            CobolElementVisitor unmarshaler = this.getCobolBindingVisitorsFactory().createUnmarshalVisitor(hostData, offset, this.getCobolConverters());
            ICobolComplexBinding binding = this.getCachedBinding();
            binding.accept(unmarshaler);
            int bytesUnmarshalled = unmarshaler.getOffset();
            if (this._log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this._log.debug((Object)("Host to Java transformation ended Processed: " + Integer.toString(bytesUnmarshalled) + " bytes " + "elapse:" + Long.toString(end - start) + " ms"));
            }
            status.setHostBytesProcessed(bytesUnmarshalled);
            status.setBinding(binding);
            return (T)binding.getObjectValue(binding.getJaxbType());
        }
        catch (HostException he) {
            throw new HostTransformException(he);
        }
    }
}

