/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IHostJsonTransformers;
import com.legstar.coxb.transform.IHostToJsonTransformer;
import com.legstar.coxb.transform.IJsonToHostTransformer;
import java.io.Reader;
import java.io.Writer;

public abstract class AbstractJsonTransformers
implements IHostJsonTransformers {
    private IJsonToHostTransformer _jsonToHost;
    private IHostToJsonTransformer _hostToJson;

    public AbstractJsonTransformers() {
    }

    public AbstractJsonTransformers(IJsonToHostTransformer jsonToHost, IHostToJsonTransformer hostToJson) {
        this._jsonToHost = jsonToHost;
        this._hostToJson = hostToJson;
    }

    public IJsonToHostTransformer getJsonToHost() {
        return this._jsonToHost;
    }

    public void setJsonToHost(IJsonToHostTransformer jsonToHost) {
        this._jsonToHost = jsonToHost;
    }

    public IHostToJsonTransformer getHostToJson() {
        return this._hostToJson;
    }

    public void setHostToJson(IHostToJsonTransformer hostToJson) {
        this._hostToJson = hostToJson;
    }

    public byte[] toHost(Reader reader, String hostCharset) throws HostTransformException {
        return this.getJsonToHost().transform(reader, hostCharset);
    }

    public byte[] toHost(Reader reader) throws HostTransformException {
        return this.getJsonToHost().transform(reader);
    }

    public void toJson(byte[] hostData, Writer writer, String hostCharset) throws HostTransformException {
        this.getHostToJson().transform(hostData, writer, hostCharset);
    }

    public void toJson(byte[] hostData, Writer writer) throws HostTransformException {
        this.getHostToJson().transform(hostData, writer);
    }

    public byte[] toHost(Reader reader, String hostCharset, HostTransformStatus status) throws HostTransformException {
        return this.getJsonToHost().transform(reader, hostCharset, status);
    }

    public byte[] toHost(Reader reader, HostTransformStatus status) throws HostTransformException {
        return this.getJsonToHost().transform(reader, status);
    }

    public void toJson(byte[] hostData, Writer writer, String hostCharset, HostTransformStatus status) throws HostTransformException {
        this.getHostToJson().transform(hostData, writer, hostCharset, status);
    }

    public void toJson(byte[] hostData, Writer writer, HostTransformStatus status) throws HostTransformException {
        this.getHostToJson().transform(hostData, writer, status);
    }
}

