/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro;

import com.legstar.avro.cob2avro.Cob2AvroVisitor;
import com.legstar.base.converter.AbstractCob2ObjectConverter;
import com.legstar.base.converter.FromHostResult;
import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class Cob2AvroGenericConverter
extends AbstractCob2ObjectConverter<GenericRecord> {
    private final Schema schema;

    public FromHostResult<GenericRecord> convert(byte[] hostData, int start, int length) {
        Cob2AvroVisitor visitor = new Cob2AvroVisitor(this.getCobolContext(), hostData, start, length, this.getCustomChoiceStrategy(), this.getCustomVariables(), this.schema);
        visitor.visit(this.getCobolComplexType());
        return new FromHostResult(visitor.getLastPos(), (Object)((GenericRecord)visitor.getResultObject()));
    }

    private Cob2AvroGenericConverter(Builder builder) {
        super((AbstractCob2ObjectConverter.Builder)builder);
        this.schema = builder.schema;
        if (this.schema == null) {
            throw new IllegalArgumentException("You must provide a valid Avro Schema");
        }
    }

    public static class Builder
    extends AbstractCob2ObjectConverter.Builder<GenericRecord, Builder> {
        private Schema schema;

        public Cob2AvroGenericConverter build() {
            return new Cob2AvroGenericConverter(this);
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder schemaFile(File schemaFile) {
            try {
                this.schema = new Schema.Parser().parse(schemaFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return this;
        }

        protected Builder self() {
            return this;
        }
    }
}

