/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro.io;

import com.legstar.avro.cob2avro.io.AbstractZosDatumReader;
import com.legstar.base.context.CobolContext;
import com.legstar.base.context.EbcdicCobolContext;
import com.legstar.base.type.composite.CobolComplexType;
import com.legstar.base.visitor.FromCobolChoiceStrategy;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;

public class ZosVarDatumReader<D>
extends AbstractZosDatumReader<D> {
    private int lastCount;
    private int residual;

    public ZosVarDatumReader(InputStream inStream, long length, CobolComplexType cobolType, Schema schema) throws IOException {
        this(inStream, length, (CobolContext)new EbcdicCobolContext(), cobolType, null, schema);
    }

    public ZosVarDatumReader(InputStream inStream, long length, CobolContext cobolContext, CobolComplexType cobolType, Schema schema) throws IOException {
        this(inStream, length, cobolContext, cobolType, null, schema);
    }

    public ZosVarDatumReader(InputStream inStream, long length, CobolContext cobolContext, CobolComplexType cobolType, FromCobolChoiceStrategy customChoiceStrategy, Schema schema) throws IOException {
        super(inStream, length, cobolContext, cobolType, customChoiceStrategy, schema);
    }

    @Override
    public AbstractZosDatumReader.ReadRecordStatus readRecord(byte[] hostBytes, int processed) throws IOException {
        if (this.getBytesPrefetched() > 0) {
            if (this.residual > 0 || this.lastCount > 0 || processed > 0) {
                throw new IOException("Data was prefetched after the first read");
            }
            this.lastCount = this.getBytesPrefetched();
            this.setBytesPrefetched(0);
        }
        this.residual = this.residual + this.lastCount - processed;
        if (this.residual == hostBytes.length) {
            this.lastCount = 0;
            return new AbstractZosDatumReader.ReadRecordStatus(this.residual);
        }
        if (this.residual > 0) {
            System.arraycopy(hostBytes, processed, hostBytes, 0, this.residual);
        }
        this.lastCount = this.read(hostBytes, this.residual, hostBytes.length - this.residual);
        if (this.lastCount == -1) {
            if (this.residual > 0) {
                this.lastCount = 0;
                return new AbstractZosDatumReader.ReadRecordStatus(this.residual);
            }
            return new AbstractZosDatumReader.ReadRecordStatus(this.lastCount);
        }
        return new AbstractZosDatumReader.ReadRecordStatus(this.residual + this.lastCount);
    }

    @Override
    public int hostBytesPrefixLen() {
        return 0;
    }
}

