/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.translator;

import com.legstar.avro.translator.Xsd2AvroTranslatorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.utils.XmlSchemaObjectBase;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xsd2AvroTranslator {
    private static final String LEGSTAR_XSD_FILE_ENCODING = "UTF-8";
    private static Logger log = LoggerFactory.getLogger(Xsd2AvroTranslator.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String CHOICE_PREFIX_FORMAT = "[choice:%s_%s]";

    public Map<String, String> translate(File xsdInput, String avroNamespacePrefix) throws IOException {
        log.info("COBOL to Avro translator started");
        HashMap<String, String> mapSchemas = new HashMap<String, String>();
        if (!xsdInput.exists()) {
            throw new IOException("Specified input '" + xsdInput.getName() + "' does not exist");
        }
        log.info("Reading legstar xsd files from " + xsdInput.getName());
        if (xsdInput.isDirectory()) {
            Collection xsdFiles = FileUtils.listFiles((File)xsdInput, (String[])new String[]{"xsd"}, (boolean)true);
            for (File xsdFile : xsdFiles) {
                this.translate(xsdFile, mapSchemas, avroNamespacePrefix);
            }
        } else {
            this.translate(xsdInput, mapSchemas, avroNamespacePrefix);
        }
        log.info("COBOL to Avro translator ended");
        return mapSchemas;
    }

    private void translate(File xsdFile, Map<String, String> mapSchemas, String avroNamespacePrefix) throws IOException {
        String xsdFileName = FilenameUtils.getBaseName((String)xsdFile.getName());
        String avroNamespace = (avroNamespacePrefix == null ? "" : avroNamespacePrefix + ".") + xsdFileName.toLowerCase();
        String avroSchema = this.translate(new InputStreamReader((InputStream)new FileInputStream(xsdFile), LEGSTAR_XSD_FILE_ENCODING), avroNamespace, xsdFileName);
        mapSchemas.put(xsdFileName, avroSchema);
        log.info("LegStar xsd {} translated to schema {}", (Object)xsdFileName, (Object)avroSchema);
    }

    public String translate(Reader reader, String avroNamespace, String avroSchemaName) throws Xsd2AvroTranslatorException {
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        XmlSchema xsd = schemaCol.read((Source)new StreamSource(reader));
        return this.translate(xsd, avroNamespace, avroSchemaName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String translate(XmlSchema xmlSchema, String avroNamespace, String avroSchemaName) throws Xsd2AvroTranslatorException {
        log.debug("XML Schema to Avro Schema translator started");
        Map items = xmlSchema.getElements();
        ObjectNode rootAvroSchema = null;
        ArrayNode avroFields = MAPPER.createArrayNode();
        if (items.size() > 1) {
            for (Map.Entry entry : items.entrySet()) {
                this.visit(xmlSchema, (XmlSchemaElement)entry.getValue(), 1, avroFields);
            }
            rootAvroSchema = this.buildAvroRecordType(avroSchemaName, avroFields);
        } else {
            if (items.size() != 1) throw new Xsd2AvroTranslatorException("XML schema does not contain a root element");
            XmlSchemaElement xsdElement = (XmlSchemaElement)items.values().iterator().next();
            if (!(xsdElement.getSchemaType() instanceof XmlSchemaComplexType)) throw new Xsd2AvroTranslatorException("XML schema does contain a root element but it is not a complex type");
            XmlSchemaComplexType xsdType = (XmlSchemaComplexType)xsdElement.getSchemaType();
            this.visit(xmlSchema, xsdType, 1, avroFields);
            rootAvroSchema = this.buildAvroRecordType(this.getAvroTypeName(xsdType), avroFields);
        }
        rootAvroSchema.put("namespace", avroNamespace == null ? "" : avroNamespace);
        log.debug("XML Schema to Avro Schema translator  ended");
        return rootAvroSchema.toString();
    }

    private ContainerNode buildAvroCompositeType(String avroRecordTypeName, ArrayNode avroFields, boolean isArray, boolean isOptional) throws Xsd2AvroTranslatorException {
        ObjectNode avroRecord = this.buildAvroRecordType(avroRecordTypeName, avroFields);
        if (isArray) {
            ObjectNode avroArray = MAPPER.createObjectNode();
            avroArray.put("type", "array");
            avroArray.put("items", (JsonNode)avroRecord);
            return avroArray;
        }
        if (isOptional) {
            ArrayNode typesArray = MAPPER.createArrayNode();
            typesArray.add((JsonNode)avroRecord);
            typesArray.add("null");
            return typesArray;
        }
        return avroRecord;
    }

    private ObjectNode buildAvroRecordType(String avroRecordTypeName, ArrayNode avroFields) throws Xsd2AvroTranslatorException {
        ObjectNode avroRecord = MAPPER.createObjectNode();
        avroRecord.put("type", "record");
        avroRecord.put("name", avroRecordTypeName);
        avroRecord.put("fields", (JsonNode)avroFields);
        return avroRecord;
    }

    private void visit(XmlSchema xmlSchema, XmlSchemaElement xsdElement, int level, ArrayNode avroFields) throws Xsd2AvroTranslatorException {
        if (xsdElement.getRef().getTarget() != null) {
            return;
        }
        log.debug("process started for element = " + xsdElement.getName());
        if (xsdElement.getSchemaType() instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType xsdType = (XmlSchemaComplexType)xsdElement.getSchemaType();
            int nextLevel = level + 1;
            ArrayNode avroChildrenFields = MAPPER.createArrayNode();
            this.visit(xmlSchema, xsdType, nextLevel, avroChildrenFields);
            ContainerNode avroRecordType = this.buildAvroCompositeType(this.getAvroTypeName(xsdType), avroChildrenFields, xsdElement.getMaxOccurs() > 1L, xsdElement.getMinOccurs() == 0L && xsdElement.getMaxOccurs() == 1L);
            ObjectNode avroRecordElement = MAPPER.createObjectNode();
            avroRecordElement.put("type", (JsonNode)avroRecordType);
            avroRecordElement.put("name", this.getAvroFieldName(xsdElement));
            avroFields.add((JsonNode)avroRecordElement);
        } else if (xsdElement.getSchemaType() instanceof XmlSchemaSimpleType) {
            this.visit((XmlSchemaSimpleType)xsdElement.getSchemaType(), level, this.getAvroFieldName(xsdElement), xsdElement.getMinOccurs(), xsdElement.getMaxOccurs(), avroFields);
        }
        log.debug("process ended for element = " + xsdElement.getName());
    }

    private void visit(XmlSchema xmlSchema, XmlSchemaComplexType xsdType, int level, ArrayNode avroFields) {
        this.visit(xmlSchema, xsdType.getParticle(), level, avroFields);
    }

    private void visit(XmlSchemaSimpleType xsdType, int level, String avroFieldName, long minOccurs, long maxOccurs, ArrayNode avroFields) throws Xsd2AvroTranslatorException {
        Object avroType = this.getAvroPrimitiveType(avroFieldName, xsdType, maxOccurs > 1L, minOccurs == 0L && maxOccurs == 1L);
        ObjectNode avroField = MAPPER.createObjectNode();
        avroField.put("name", avroFieldName);
        if (avroType != null) {
            if (avroType instanceof String) {
                avroField.put("type", (String)avroType);
            } else if (avroType instanceof JsonNode) {
                avroField.put("type", (JsonNode)avroType);
            }
        }
        avroFields.add((JsonNode)avroField);
    }

    private void visit(XmlSchema xmlSchema, XmlSchemaParticle particle, int level, ArrayNode avroFields) {
        if (particle.getMaxOccurs() > 1L) {
            log.warn("Schema object at line " + particle.getLineNumber() + " contains a multi-occurence particle that is ignored");
        }
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
            for (XmlSchemaSequenceMember member : sequence.getItems()) {
                this.visit(xmlSchema, (XmlSchemaObjectBase)member, level, avroFields);
            }
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaAll all = (XmlSchemaAll)particle;
            for (XmlSchemaAllMember member : all.getItems()) {
                this.visit(xmlSchema, (XmlSchemaObjectBase)member, level, avroFields);
            }
        } else {
            log.warn("Schema object does not contain a sequence or all element at line " + particle.getLineNumber());
        }
    }

    private void visit(XmlSchema xmlSchema, XmlSchemaObjectBase element, int level, ArrayNode avroFields) {
        if (element instanceof XmlSchemaElement) {
            this.visit(xmlSchema, (XmlSchemaElement)element, level, avroFields);
        } else if (element instanceof XmlSchemaGroupRef) {
            XmlSchemaGroupRef groupRef = (XmlSchemaGroupRef)element;
            XmlSchemaGroup group = (XmlSchemaGroup)xmlSchema.getGroups().get(groupRef.getRefName());
            this.visit(xmlSchema, (XmlSchemaParticle)group.getParticle(), level, avroFields);
        } else if (element instanceof XmlSchemaChoice) {
            this.visit(xmlSchema, (XmlSchemaChoice)element, level, avroFields);
        }
    }

    private void visit(XmlSchema xmlSchema, XmlSchemaChoice xsdChoice, int level, ArrayNode avroFields) throws Xsd2AvroTranslatorException {
        log.debug("process started for choice");
        String firstAlternativeName = null;
        ArrayNode alternativeAvroFields = MAPPER.createArrayNode();
        for (XmlSchemaChoiceMember alternative : xsdChoice.getItems()) {
            if (!(alternative instanceof XmlSchemaElement)) continue;
            String alternativeName = this.getAvroFieldName((XmlSchemaElement)alternative);
            if (firstAlternativeName == null) {
                firstAlternativeName = alternativeName;
            }
            this.visit(xmlSchema, (XmlSchemaElement)alternative, level, alternativeAvroFields);
        }
        ObjectNode avroChoiceField = MAPPER.createObjectNode();
        avroChoiceField.put("name", firstAlternativeName + "Choice");
        ArrayNode alternativeAvroTypes = MAPPER.createArrayNode();
        for (int i = 0; i < alternativeAvroFields.size(); ++i) {
            alternativeAvroTypes.add(alternativeAvroFields.get(i).get("type"));
        }
        avroChoiceField.put("type", (JsonNode)alternativeAvroTypes);
        avroFields.add((JsonNode)avroChoiceField);
        log.debug("process ended for choice = " + firstAlternativeName + "Choice");
    }

    private Object getAvroPrimitiveType(String avroFieldName, XmlSchemaSimpleType xsdType, boolean isArray, boolean isOptional) throws Xsd2AvroTranslatorException {
        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)xsdType.getContent();
        if (restriction != null && restriction.getBaseTypeName() != null) {
            QName xsdTypeName = restriction.getBaseTypeName();
            ObjectNode avroType = null;
            String avroPrimitiveType = this.getAvroPrimitiveType(xsdTypeName);
            if (avroPrimitiveType == null) {
                return null;
            }
            if ("fixed".equals(avroPrimitiveType)) {
                if (restriction.getFacets() == null) {
                    throw new Xsd2AvroTranslatorException("Binary type without facets in " + avroFieldName);
                }
                avroType = MAPPER.createObjectNode();
                avroType.put("type", "fixed");
                avroType.put("name", StringUtils.capitalize((String)avroFieldName));
                for (XmlSchemaFacet facet : restriction.getFacets()) {
                    if (!(facet instanceof XmlSchemaMaxLengthFacet)) continue;
                    XmlSchemaMaxLengthFacet xsef = (XmlSchemaMaxLengthFacet)facet;
                    avroType.put("size", Integer.parseInt((String)xsef.getValue()));
                }
            } else if ("decimal".equals(avroPrimitiveType)) {
                if (restriction.getFacets() == null) {
                    throw new Xsd2AvroTranslatorException("Decimal type without facets in " + avroFieldName);
                }
                avroType = MAPPER.createObjectNode();
                avroType.put("type", "bytes");
                avroType.put("logicalType", "decimal");
                for (XmlSchemaFacet facet : restriction.getFacets()) {
                    if (facet instanceof XmlSchemaTotalDigitsFacet) {
                        avroType.put("precision", Integer.parseInt((String)facet.getValue()));
                        continue;
                    }
                    if (!(facet instanceof XmlSchemaFractionDigitsFacet)) continue;
                    avroType.put("scale", Integer.parseInt((String)facet.getValue()));
                }
            }
            if (isArray) {
                ObjectNode avroArrayType = MAPPER.createObjectNode();
                avroArrayType.put("type", "array");
                if (avroType == null) {
                    avroArrayType.put("items", avroPrimitiveType);
                } else {
                    avroArrayType.put("items", (JsonNode)avroType);
                }
                return avroArrayType;
            }
            if (isOptional) {
                ArrayNode typesArray = MAPPER.createArrayNode();
                if (avroType == null) {
                    typesArray.add(avroPrimitiveType);
                } else {
                    typesArray.add((JsonNode)avroType);
                }
                typesArray.add("null");
                return typesArray;
            }
            if (avroType == null) {
                return avroPrimitiveType;
            }
            return avroType;
        }
        log.warn("Simple type without restriction " + xsdType.getName());
        return null;
    }

    private String getAvroPrimitiveType(QName xsdTypeName) {
        if (xsdTypeName.equals(Constants.XSD_STRING)) {
            return "string";
        }
        if (xsdTypeName.equals(Constants.XSD_INT)) {
            return "int";
        }
        if (xsdTypeName.equals(Constants.XSD_INTEGER)) {
            return "long";
        }
        if (xsdTypeName.equals(Constants.XSD_LONG)) {
            return "long";
        }
        if (xsdTypeName.equals(Constants.XSD_SHORT)) {
            return "int";
        }
        if (xsdTypeName.equals(Constants.XSD_DECIMAL)) {
            return "decimal";
        }
        if (xsdTypeName.equals(Constants.XSD_FLOAT)) {
            return "float";
        }
        if (xsdTypeName.equals(Constants.XSD_DOUBLE)) {
            return "double";
        }
        if (xsdTypeName.equals(Constants.XSD_HEXBIN)) {
            return "fixed";
        }
        if (xsdTypeName.equals(Constants.XSD_UNSIGNEDINT)) {
            return "long";
        }
        if (xsdTypeName.equals(Constants.XSD_UNSIGNEDSHORT)) {
            return "int";
        }
        if (xsdTypeName.equals(Constants.XSD_UNSIGNEDLONG)) {
            return "long";
        }
        log.warn("Unable to derive Avro type from " + xsdTypeName.getLocalPart());
        return null;
    }

    public String getAvroFieldName(XmlSchemaElement xsdElement) {
        return StringUtils.uncapitalize((String)xsdElement.getName());
    }

    public String getAvroTypeName(XmlSchemaComplexType xsdType) {
        return xsdType.getName();
    }
}

