/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.translator;

import com.legstar.avro.translator.Xsd2AvroTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xsd2AvroTranslatorMain {
    private static final String OPTION_AVRO_NAMESPACE_PREFIX = "namespace";
    private static final String OPTION_OUTPUT = "output";
    private static final String OPTION_INPUT = "input";
    private static final String OPTION_HELP = "help";
    private static final String OPTION_VERSION = "version";
    private static Logger log = LoggerFactory.getLogger(Xsd2AvroTranslatorMain.class);
    private static final String DEFAULT_INPUT_FOLDER_PATH = "xsd";
    private static final String DEFAULT_OUTPUT_FOLDER_PATH = "target/gen";
    private static final String DEFAULT_AVRO_NAMESPACE_PREFIX = "example.avro";
    private File xsdInput;
    private File output;
    private String avroNamespacePrefix;

    public static void main(String[] args) {
        Xsd2AvroTranslatorMain main = new Xsd2AvroTranslatorMain();
        main.execute(args);
    }

    public void execute(String[] args) {
        try {
            Options options = this.createOptions();
            if (this.collectOptions(options, args)) {
                this.setDefaults();
                this.generate();
            }
        }
        catch (Exception e) {
            log.error("COBOL to Avro translation failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void generate() {
        try {
            FileUtils.forceMkdir((File)this.output);
            Xsd2AvroTranslator translator = new Xsd2AvroTranslator();
            Map<String, String> mapSchemas = translator.translate(this.xsdInput, this.avroNamespacePrefix);
            for (Map.Entry<String, String> entry : mapSchemas.entrySet()) {
                FileUtils.writeStringToFile((File)new File(this.output, entry.getKey() + ".avsc"), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            log.error("Generation failed for input " + this.xsdInput.getName(), (Throwable)e);
        }
    }

    private Options createOptions() {
        Options options = new Options();
        Option version = new Option("v", OPTION_VERSION, false, "print the version information and exit");
        options.addOption(version);
        Option help = new Option("h", OPTION_HELP, false, "print the options available");
        options.addOption(help);
        Option input = new Option("i", OPTION_INPUT, true, "file or folder holding the COBOL annotated XML schemas to translate. Name is relative or absolute");
        options.addOption(input);
        Option output = new Option("o", OPTION_OUTPUT, true, "folder receiving the generated artifacts");
        options.addOption(output);
        Option namespacePrefix = new Option("np", OPTION_AVRO_NAMESPACE_PREFIX, true, "avro namespace prefix to use for generated java packages");
        options.addOption(namespacePrefix);
        return options;
    }

    private boolean collectOptions(Options options, String[] args) throws Exception {
        if (args != null && args.length > 0) {
            PosixParser parser = new PosixParser();
            CommandLine line = parser.parse(options, args);
            return this.processLine(line, options);
        }
        return true;
    }

    private boolean processLine(CommandLine line, Options options) throws Exception {
        if (line.hasOption(OPTION_VERSION)) {
            log.info(this.getVersion(true));
            return false;
        }
        if (line.hasOption(OPTION_HELP)) {
            this.produceHelp(options);
            return false;
        }
        if (line.hasOption(OPTION_INPUT)) {
            this.setXsdInput(line.getOptionValue(OPTION_INPUT).trim());
        }
        if (line.hasOption(OPTION_OUTPUT)) {
            this.setOutput(line.getOptionValue(OPTION_OUTPUT).trim());
        }
        if (line.hasOption(OPTION_AVRO_NAMESPACE_PREFIX)) {
            this.setAvroNamespacePrefix(line.getOptionValue(OPTION_AVRO_NAMESPACE_PREFIX).trim());
        }
        return true;
    }

    private String getVersion(boolean verbose) {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/version.properties");
            Properties props = new Properties();
            props.load(stream);
            if (verbose) {
                return String.format("Version=%s, build date=%s", props.getProperty(OPTION_VERSION), props.getProperty("buildDate"));
            }
            return props.getProperty(OPTION_VERSION);
        }
        catch (IOException e) {
            log.error("Unable to retrieve version", (Throwable)e);
            return "unknown";
        }
    }

    private void produceHelp(Options options) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        String version = this.getVersion(false);
        formatter.printHelp("java -jar com.legstar.avro.translator-" + version + "-exe.jar followed by:", options);
    }

    private void setDefaults() {
        if (this.xsdInput == null) {
            this.setXsdInput(DEFAULT_INPUT_FOLDER_PATH);
        }
        if (this.output == null) {
            this.setOutput(DEFAULT_OUTPUT_FOLDER_PATH);
        }
        if (this.avroNamespacePrefix == null) {
            this.setAvroNamespacePrefix(DEFAULT_AVRO_NAMESPACE_PREFIX);
        }
    }

    public void setXsdInput(String xsdInputPath) {
        if (xsdInputPath == null) {
            throw new IllegalArgumentException("You must provide a source folder or file");
        }
        File xsdInput = new File(xsdInputPath);
        if (xsdInput.exists()) {
            if (xsdInput.isDirectory() && xsdInput.list().length == 0) {
                throw new IllegalArgumentException("Folder '" + xsdInputPath + "' is empty");
            }
        } else {
            throw new IllegalArgumentException("Input file or folder '" + xsdInputPath + "' not found");
        }
        this.xsdInput = xsdInput;
    }

    public void setOutput(String output) {
        if (output == null) {
            throw new IllegalArgumentException("You must provide a target folder or file");
        }
        this.output = new File(output);
    }

    public void setAvroNamespacePrefix(String avroNamespacePrefix) {
        this.avroNamespacePrefix = avroNamespacePrefix;
    }
}

