/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.ValidationFailureMisplacedOption;
import com.lexicalscope.jewel.cli.parser.ParsedArguments;
import com.lexicalscope.jewel.cli.validation.ArgumentValidator;
import com.lexicalscope.jewel.cli.validation.OptionCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgumentCollectionBuilder
implements ParsedArguments {
    private final Map<String, List<String>> arguments = new LinkedHashMap<String, List<String>>();
    private final List<String> unparsed = new ArrayList<String>();
    private IParsingState state = new Initial();
    private List<String> valuesForCurrentArgument;

    @Override
    public void unparsedOptionsFollow() {
        this.state = new UnparsedState();
    }

    @Override
    public void addValue(String value) {
        this.state = this.state.addValue(value);
    }

    @Override
    public void addOption(String option) {
        this.state = this.state.addOption(option);
    }

    public OptionCollection processArguments(ArgumentValidator argumentProcessor) {
        Set<Map.Entry<String, List<String>>> entrySet = this.arguments.entrySet();
        Iterator<Map.Entry<String, List<String>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            if (iterator.hasNext()) {
                argumentProcessor.processOption(entry.getKey(), entry.getValue());
                continue;
            }
            argumentProcessor.processLastOption(entry.getKey(), entry.getValue());
        }
        argumentProcessor.processUnparsed(this.unparsed);
        return argumentProcessor.finishedProcessing();
    }

    private ArgumentValidationException misplacedOption(String option) {
        return new ArgumentValidationException(new ValidationFailureMisplacedOption(option));
    }

    private void addUnparsedValue(String value) {
        this.unparsed.add(value);
    }

    private void addFirstValueForOption(String option) {
        if (!this.arguments.containsKey(option)) {
            this.valuesForCurrentArgument = new ArrayList<String>();
            this.arguments.put(option, this.valuesForCurrentArgument);
        }
        this.valuesForCurrentArgument = this.arguments.get(option);
    }

    private class OptionOrValue
    implements IParsingState {
        public OptionOrValue(String option) {
            ArgumentCollectionBuilder.this.addFirstValueForOption(option);
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.valuesForCurrentArgument.add(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) {
            return new OptionOrValue(option);
        }
    }

    private class UnparsedState
    implements IParsingState {
        public UnparsedState() {
            ArgumentCollectionBuilder.this.valuesForCurrentArgument = null;
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) throws ArgumentValidationException {
            throw ArgumentCollectionBuilder.this.misplacedOption(option);
        }
    }

    private class NoOptions
    implements IParsingState {
        public NoOptions(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) throws ArgumentValidationException {
            throw ArgumentCollectionBuilder.this.misplacedOption(option);
        }
    }

    private class Initial
    implements IParsingState {
        private Initial() {
        }

        @Override
        public IParsingState addValue(String value) {
            return new NoOptions(value);
        }

        @Override
        public IParsingState addOption(String option) {
            return new OptionOrValue(option);
        }
    }

    private static interface IParsingState {
        public IParsingState addValue(String var1);

        public IParsingState addOption(String var1) throws ArgumentValidationException;
    }
}

