/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ThemeMergeMojo
extends AbstractMojo {
    private ArchiverManager archiverManager;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private String liferayVersion;
    private ArtifactRepository localArtifactRepository;
    private String parentTheme;
    private List remoteArtifactRepositories;
    private String themeType;
    private File webappDirectory;
    private File workDir;

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void doExecute() throws Exception {
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        String parentThemeGroupId = "com.liferay.portal";
        String parentThemeArtifactId = "portal-web";
        String parentThemeVersion = this.liferayVersion;
        String[] excludes = new String[]{"html/themes/classic/_diffs/**", "html/themes/control_panel/_diffs/**"};
        String[] includes = new String[]{"html/themes/_unstyled/**", "html/themes/_styled/**", "html/themes/classic/**", "html/themes/control_panel/**"};
        if (!(this.parentTheme.equals("_styled") || this.parentTheme.equals("_unstyled") || this.parentTheme.equals("classic") || this.parentTheme.equals("control_panel"))) {
            String[] parentThemeArray = this.parentTheme.split(":");
            parentThemeGroupId = parentThemeArray[0];
            parentThemeArtifactId = parentThemeArray[1];
            parentThemeVersion = parentThemeArray[2];
            excludes = new String[]{"WEB-INF/**"};
        }
        Artifact artifact = this.artifactFactory.createArtifact(parentThemeGroupId, parentThemeArtifactId, parentThemeVersion, "", "war");
        this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localArtifactRepository);
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
        unArchiver.setDestDirectory(this.workDir);
        unArchiver.setSourceFile(artifact.getFile());
        IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
        includeExcludeFileSelector.setExcludes(excludes);
        includeExcludeFileSelector.setIncludes(includes);
        unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
        unArchiver.extract();
        this.webappDirectory.mkdirs();
        if (parentThemeArtifactId.equals("portal-web")) {
            FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/_unstyled"), (File)this.webappDirectory);
            this.getLog().info((CharSequence)("Copying html/themes/_unstyled to " + this.webappDirectory));
            if (!"_unstyled".equals(this.parentTheme)) {
                FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/_styled"), (File)this.webappDirectory);
                this.getLog().info((CharSequence)("Copying html/themes/_styled to " + this.webappDirectory));
            }
            if (!"_unstyled".equals(this.parentTheme) && !"_styled".equals(this.parentTheme)) {
                FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/" + this.parentTheme), (File)this.webappDirectory);
                this.getLog().info((CharSequence)("Copying html/themes/" + this.parentTheme + " to " + this.webappDirectory));
            }
        } else {
            FileUtils.copyDirectory((File)this.workDir, (File)this.webappDirectory);
        }
        File initFile = new File(this.webappDirectory, "templates/init." + this.themeType);
        FileUtils.deleteQuietly((File)initFile);
        File templatesDirectory = new File(this.webappDirectory, "templates/");
        String[] extensions = null;
        extensions = this.themeType.equals("ftl") ? new String[]{"vm"} : new String[]{"ftl"};
        Iterator itr = FileUtils.iterateFiles((File)templatesDirectory, (String[])extensions, (boolean)false);
        while (itr.hasNext()) {
            File file = (File)itr.next();
            FileUtils.deleteQuietly((File)file);
        }
    }
}

