/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.DTBuilder;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.PeriodValue;
import com.google.ical.values.PeriodValueImpl;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcalParseUtil {
    private static final Pattern DATE_VALUE = Pattern.compile("(\\d{4,})(\\d\\d)(\\d\\d)(?:T([0-1]\\d|2[0-3])([0-5]\\d)([0-5]\\d)(Z)?)?");
    private static final Pattern IGNORABLE_ICAL_WHITESPACE = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");

    public static DateValue parseDateValue(String s) throws ParseException {
        return IcalParseUtil.parseDateValue(s, null);
    }

    public static DateValue parseDateValue(String s, TimeZone tzid) throws ParseException {
        Matcher m = DATE_VALUE.matcher(s);
        if (!m.matches()) {
            throw new ParseException(s, 0);
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int day = Integer.parseInt(m.group(3));
        if (null != m.group(4)) {
            int hour = Integer.parseInt(m.group(4));
            int minute = Integer.parseInt(m.group(5));
            int second = Integer.parseInt(m.group(6));
            boolean utc = null != m.group(7);
            DateValue dv = new DTBuilder(year, month, day, hour, minute, second).toDateTime();
            if (!utc && null != tzid) {
                dv = TimeUtils.toUtc(dv, tzid);
            }
            return dv;
        }
        return new DTBuilder(year, month, day).toDate();
    }

    public static PeriodValue parsePeriodValue(String s) throws ParseException {
        return IcalParseUtil.parsePeriodValue(s, null);
    }

    public static PeriodValue parsePeriodValue(String s, TimeZone tzid) throws ParseException {
        DateValue end;
        int sep = s.indexOf(47);
        if (sep < 0) {
            throw new ParseException(s, s.length());
        }
        DateValue start = IcalParseUtil.parseDateValue(s.substring(0, sep), tzid);
        if (start instanceof TimeValue != (end = IcalParseUtil.parseDateValue(s.substring(sep + 1), tzid)) instanceof TimeValue) {
            throw new ParseException(s, 0);
        }
        try {
            return PeriodValueImpl.create(start, end);
        }
        catch (IllegalArgumentException ex) {
            throw (ParseException)new ParseException(s, sep + 1).initCause(ex);
        }
    }

    public static String unfoldIcal(String foldedContentLines) {
        return IGNORABLE_ICAL_WHITESPACE.matcher(foldedContentLines).replaceAll("");
    }

    private IcalParseUtil() {
    }
}

