/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.ant.BndTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.service.IndexProvider;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public abstract class BaseBndTask
extends BndTask {
    protected org.apache.tools.ant.Project project;
    private static final String _BND_DIR = ".bnd";
    private File _bndDir;
    private String _bndDirName;
    private File _bndRootFile;

    public void execute() throws BuildException {
        try {
            this.project = this.getProject();
            this.doBeforeExecute();
            this.doExecute();
        }
        catch (Exception e) {
            if (e instanceof BuildException) {
                throw (BuildException)e;
            }
            throw new BuildException((Throwable)e);
        }
    }

    public Project getBndProject() throws Exception {
        File bndRootFile = this.getBndRootFile();
        Workspace workspace = Workspace.getWorkspace((File)bndRootFile.getParentFile(), (String)this.getBndDirName());
        workspace.setProperties(bndRootFile);
        Project bndProject = new Project(workspace, bndRootFile.getParentFile());
        bndProject.setFileMustExist(true);
        bndProject.setProperties(bndRootFile);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        properties.putAll((Map<?, ?>)bndProject.getProperties());
        bndProject.setProperties(properties);
        Set plugins = workspace.getPlugins();
        for (Object plugin : plugins) {
            if (!(plugin instanceof IndexProvider)) continue;
            IndexProvider indexProvider = (IndexProvider)plugin;
            indexProvider.getIndexLocations();
        }
        return bndProject;
    }

    public File getBndRootFile() {
        return this._bndRootFile;
    }

    public void setBndRootFile(File bndRootFile) {
        this._bndRootFile = bndRootFile;
    }

    protected void doBeforeExecute() throws Exception {
        if (this._bndRootFile == null || !this._bndRootFile.exists() || this._bndRootFile.isDirectory()) {
            if (this._bndRootFile != null) {
                this.project.log("bndRootFile is either missing or is a directory " + this._bndRootFile.getAbsolutePath(), 0);
            }
            throw new Exception("bndRootFile is invalid");
        }
        this._bndRootFile = this._bndRootFile.getAbsoluteFile();
        File rootDir = this._bndRootFile.getParentFile();
        this._bndDir = new File(rootDir, this.getBndDirName());
        if (!rootDir.canWrite()) {
            return;
        }
        if (!this._bndDir.exists() && !this._bndDir.mkdir()) {
            return;
        }
        File buildFile = new File(this._bndDir, "build.bnd");
        if (buildFile.exists() || !this._bndDir.canWrite()) {
            return;
        }
        buildFile.createNewFile();
    }

    protected abstract void doExecute() throws Exception;

    protected String getBndDirName() {
        if (this._bndDirName != null) {
            return this._bndDirName;
        }
        this._bndDirName = this.project.getProperty("baseline.jar.bnddir.name");
        if (this._bndDirName == null) {
            this._bndDirName = _BND_DIR;
        }
        return this._bndDirName;
    }
}

