/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.build.Project;
import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.BaseBndTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;

public class ReleaseToRepoTask
extends BaseBndTask {
    private String _deployRepo;
    private File _file;

    public void setDeployRepo(String name) {
        this._deployRepo = name;
    }

    public void setFile(File file) {
        this._file = file;
    }

    @Override
    protected void doBeforeExecute() throws Exception {
        super.doBeforeExecute();
        if (this._file == null || !this._file.exists() || this._file.isDirectory()) {
            if (this._file != null) {
                this.project.log("file is either missing or is a directory " + this._file.getAbsolutePath(), 0);
            }
            throw new BuildException("file is invalid");
        }
    }

    @Override
    protected void doExecute() throws Exception {
        Project bndProject = this.getBndProject();
        try {
            if (this._file.isFile() && this._file.getName().endsWith(".jar")) {
                if (this._deployRepo != null) {
                    bndProject.deploy(this._deployRepo, this._file);
                } else {
                    bndProject.deploy(this._file);
                }
            } else {
                this.project.log("Not a JAR file " + this._file.getAbsolutePath(), 0);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e, new Location(this._file.getAbsolutePath()));
        }
        this.report((Reporter)bndProject);
        if (bndProject.getErrors().size() > 0) {
            throw new BuildException("Unable to deploy", new Location(this._file.getAbsolutePath()));
        }
    }
}

