/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.osgi.Processor;
import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.BaseBndTask;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class TestTask
extends BaseBndTask {
    private boolean _continuous;
    private File _dir;
    private String _runFiles;

    public void setContinuous(boolean continuous) {
        this._continuous = continuous;
    }

    public void setDir(File dir) {
        this._dir = dir;
    }

    public void setRunFiles(String runFiles) {
        this._runFiles = runFiles;
    }

    @Override
    protected void doExecute() throws Exception {
        File baseDir = this.project.getBaseDir();
        Project bndProject = this.getBndProject();
        try {
            List<Project> projects = null;
            if (this._runFiles == null) {
                projects = Collections.singletonList(bndProject);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this._runFiles, ",");
                projects = new LinkedList<Project>();
                while (stringTokenizer.hasMoreTokens()) {
                    String runFilePath = stringTokenizer.nextToken();
                    runFilePath = runFilePath.trim();
                    Project runProject = null;
                    if (runFilePath.equals(".")) {
                        runProject = bndProject;
                    } else {
                        File runFile = new File(baseDir, runFilePath);
                        if (!runFile.isFile()) {
                            throw new BuildException(String.format("Run file %s does not exist or is not a file", runFile.getAbsolutePath()));
                        }
                        runProject = new Project(bndProject.getWorkspace(), baseDir, runFile);
                        runProject.setParent((Processor)bndProject);
                    }
                    projects.add(runProject);
                }
            }
            for (Project project : projects) {
                project.clear();
            }
            for (Project project : projects) {
                this.executeProject(project);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void executeProject(Project project) throws Exception {
        this.project.log("Testing " + project.getPropertiesFile());
        ProjectTester projectTester = project.getProjectTester();
        projectTester.setContinuous(this._continuous);
        if (this._dir != null) {
            projectTester.setCwd(this._dir);
        }
        String testerDir = project.getProperty("tester.dir", "test-reports");
        File reportDir = new File(project.getBase(), testerDir);
        projectTester.setReportDir(reportDir);
        projectTester.prepare();
        if (this.report((Reporter)project)) {
            throw new BuildException("Unable to initialise for testing");
        }
        int errors = projectTester.test();
        if (errors != 0) {
            if (errors == 1) {
                this.project.log(errors + " Error", 0);
            } else {
                this.project.log(errors + " Errors", 0);
            }
            throw new BuildException("Tests failed");
        }
        this.project.log("All tests passed");
        if (this.report((Reporter)project)) {
            throw new BuildException("Tests failed");
        }
    }
}

