/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.npm;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.version.Version;
import aQute.lib.json.Decoder;
import aQute.lib.json.JSONCodec;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NpmAnalyzerPlugin
implements AnalyzerPlugin {
    public static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String _OSGI_WEBRESOURCE = "osgi.webresource";
    private static final String _VERSION = "((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)";
    private static final String _VERSION_INCLUSIVE_RANGE = "((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)\\s*-\\s*((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)";
    private static final String _VERSION_NAMED = "(?<major>\\d{1,9})(\\.(?<minor>[\\dx\\*]{1,9})(\\.(?<micro>[\\dx\\*]{1,9})([\\.-](?<qualifier>[-_\\da-zA-Z]+))?)?)?";
    private static final String _VERSION_PREFIX_RANGE = "(<|<=|>|>=|=|~|\\^|v)";
    private static final String _VERSION_RANGE = "((<|<=|>|>=|=|~|\\^|v)((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?))\\s+((<|<=|>|>=|=|~|\\^|v)((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?))";
    private static final Pattern _versionInclusiveRangePattern = Pattern.compile("((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)\\s*-\\s*((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)");
    private static final Pattern _versionNamedPattern = Pattern.compile("(?<major>\\d{1,9})(\\.(?<minor>[\\dx\\*]{1,9})(\\.(?<micro>[\\dx\\*]{1,9})([\\.-](?<qualifier>[-_\\da-zA-Z]+))?)?)?");
    private static final Pattern _versionPrefixRangePattern = Pattern.compile("(<|<=|>|>=|=|~|\\^|v)((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?)");
    private static final Pattern _versionRangePattern = Pattern.compile("((<|<=|>|>=|=|~|\\^|v)((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?))\\s+((<|<=|>|>=|=|~|\\^|v)((\\d{1,9})(\\.([\\dx\\*]{1,9})(\\.([\\dx\\*]{1,9})([\\.-]([-_\\da-zA-Z]+))?)?)?))");

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Jar jar = analyzer.getJar();
        Resource npmJSONResource = jar.getResource("package.json");
        if (npmJSONResource == null) {
            return false;
        }
        NpmModule npmModule = this.processNpmJsonResource(analyzer, npmJSONResource);
        this.processDependencies(analyzer, npmModule);
        return false;
    }

    protected void appendInclusive(StringBuilder sb, String group1, String group2) {
        sb.append("(&(version>=");
        Matcher matcher = _versionNamedPattern.matcher(group1);
        matcher.matches();
        String major = matcher.group("major");
        String minor = matcher.group("minor");
        String micro = matcher.group("micro");
        String qualifier = matcher.group("qualifier");
        sb.append(this.toVersion(major, minor, micro, qualifier));
        matcher = _versionNamedPattern.matcher(group2);
        matcher.matches();
        major = matcher.group("major");
        minor = matcher.group("minor");
        micro = matcher.group("micro");
        qualifier = matcher.group("qualifier");
        if (minor == null) {
            major = Integer.parseInt(major) + 1 + "";
            sb.append(")(!(version>=");
            sb.append(major);
            sb.append(".0.0)");
        } else if (micro == null) {
            sb.append(")(version<=");
            sb.append(major);
            sb.append(".");
            sb.append(Integer.parseInt(minor) + 1);
            sb.append(".0");
        } else {
            sb.append(")(version<=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
        }
        sb.append("))");
    }

    protected void appendPrefixRange(StringBuilder sb, String prefix, String version) {
        Matcher matcher = _versionNamedPattern.matcher(version);
        matcher.matches();
        String major = matcher.group("major");
        String minor = matcher.group("minor");
        String micro = matcher.group("micro");
        String qualifier = matcher.group("qualifier");
        if (prefix.equals("v") || prefix.equals("=")) {
            sb.append("(version=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")");
        } else if (prefix.equals("<")) {
            sb.append("(!(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append("))");
        } else if (prefix.equals("<=")) {
            sb.append("(version<=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")");
        } else if (prefix.equals(">")) {
            sb.append("(&(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")(!(version=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")))");
        } else if (prefix.equals(">=")) {
            sb.append("(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")");
        } else if (prefix.equals("~")) {
            sb.append("(&(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")(!(version>=");
            if (minor != null) {
                sb.append(major);
                sb.append(".");
                sb.append(Integer.parseInt(minor) + 1);
                sb.append(".0");
            } else {
                sb.append(Integer.parseInt(major) + 1);
                sb.append(".0.0");
            }
            sb.append(")))");
        } else if (prefix.equals("^")) {
            sb.append("(&(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")(!(version>=");
            if (!major.equals("0") || minor.equalsIgnoreCase("x") || minor.equals("*")) {
                sb.append(Integer.parseInt(major) + 1);
                sb.append(".0.0");
            } else if (!minor.equals("0") || micro == null || micro.equalsIgnoreCase("x") || micro.equals("*")) {
                sb.append("0.");
                sb.append(Integer.parseInt(this.desugar(minor)) + 1);
                sb.append(".0");
            } else {
                sb.append("0.0.");
                sb.append(Integer.parseInt(this.desugar(micro)) + 1);
            }
            sb.append(")))");
        }
    }

    protected void appendRange(StringBuilder sb, String group1, String group2) {
        sb.append("(&");
        Matcher matcher = _versionPrefixRangePattern.matcher(group1);
        matcher.matches();
        this.appendPrefixRange(sb, matcher.group(1), matcher.group(2));
        matcher = _versionPrefixRangePattern.matcher(group2);
        matcher.matches();
        this.appendPrefixRange(sb, matcher.group(1), matcher.group(2));
        sb.append(")");
    }

    protected void appendVersion(StringBuilder sb, Matcher matcher) {
        String major = matcher.group("major");
        String minor = matcher.group("minor");
        String micro = matcher.group("micro");
        String qualifier = matcher.group("qualifier");
        if (minor == null || minor.equalsIgnoreCase("x") || minor.equals("*")) {
            sb.append("(&(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")(!(version>=");
            sb.append(Integer.parseInt(major) + 1);
            sb.append(".0.0)))");
        } else if (micro == null || micro.equalsIgnoreCase("x") || micro.equals("*")) {
            sb.append("(&(version>=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")(!(version>=");
            sb.append(major);
            sb.append(".");
            sb.append(Integer.parseInt(minor) + 1);
            sb.append(".0)))");
        } else {
            sb.append("(version=");
            sb.append(this.toVersion(major, minor, micro, qualifier));
            sb.append(")");
        }
    }

    protected String desugar(String minor) {
        if (minor == null || minor.equalsIgnoreCase("x") || minor.equals("*")) {
            return "0";
        }
        return minor;
    }

    protected NpmModule getNpmModule(InputStream inputStream) throws Exception {
        JSONCodec jsonCodec = new JSONCodec();
        Decoder decoder = jsonCodec.dec();
        decoder = decoder.from(inputStream);
        return (NpmModule)decoder.get(NpmModule.class);
    }

    protected String getNpmVersionFilter(String version) {
        StringBuilder sb = new StringBuilder();
        String[] comparatorSets = version.split("\\|\\|");
        if (comparatorSets.length > 1) {
            sb.append("(|");
        }
        for (String comparatorSet : comparatorSets) {
            if ((comparatorSet = comparatorSet.trim()).length() == 0 || comparatorSet.equals("*")) {
                comparatorSet = ">=0";
            }
            Matcher inclusiveMatcher = _versionInclusiveRangePattern.matcher(comparatorSet);
            Matcher rangeMatcher = _versionRangePattern.matcher(comparatorSet);
            Matcher prefixRangeMatcher = _versionPrefixRangePattern.matcher(comparatorSet);
            Matcher versionMatcher = _versionNamedPattern.matcher(comparatorSet);
            if (inclusiveMatcher.matches()) {
                this.appendInclusive(sb, inclusiveMatcher.group(1), inclusiveMatcher.group(9));
                continue;
            }
            if (rangeMatcher.matches()) {
                this.appendRange(sb, rangeMatcher.group(1), rangeMatcher.group(11));
                continue;
            }
            if (prefixRangeMatcher.matches()) {
                this.appendPrefixRange(sb, prefixRangeMatcher.group(1), prefixRangeMatcher.group(2));
                continue;
            }
            if (!versionMatcher.matches()) continue;
            this.appendVersion(sb, versionMatcher);
        }
        if (comparatorSets.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected void processDependencies(Analyzer analyzer, NpmModule npmModule) {
        if (npmModule.runtime == null) {
            return;
        }
        Parameters parameters = new Parameters();
        for (Map.Entry<String, String> entry : npmModule.runtime.entrySet()) {
            Attrs attrs = new Attrs();
            StringBuilder sb = new StringBuilder();
            sb.append("(&(");
            sb.append(_OSGI_WEBRESOURCE);
            sb.append("=");
            String name = entry.getKey();
            sb.append(name);
            sb.append(")");
            String version = entry.getValue();
            sb.append(this.getNpmVersionFilter(version));
            sb.append(")");
            attrs.put("filter:", sb.toString());
            parameters.add(_OSGI_WEBRESOURCE, attrs);
        }
        this.setCapabilities(analyzer, "Require-Capability", parameters);
    }

    protected NpmModule processNpmJsonResource(Analyzer analyzer, Resource npmJSONResource) throws Exception {
        NpmModule npmModule = this.getNpmModule(npmJSONResource.openInputStream());
        String bundleVersion = analyzer.getBundleVersion();
        if (bundleVersion == null) {
            Version version = null;
            try {
                version = new Version(npmModule.version);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String sanitizedQualifier = npmModule.version.replaceAll("[^-_\\da-zA-Z]", "");
                version = new Version("0.0.0." + sanitizedQualifier);
            }
            analyzer.setBundleVersion(version.toString());
        }
        Parameters parameters = new Parameters();
        Attrs attrs = new Attrs();
        String npmName = npmModule.name;
        String webContextPath = analyzer.getProperty(WEB_CONTEXT_PATH);
        if (webContextPath == null && npmName != null) {
            if (npmName.indexOf(47) == 0) {
                npmName = npmName.substring(1);
            }
            analyzer.setProperty(WEB_CONTEXT_PATH, '/' + npmName + "-" + analyzer.getBundleVersion());
        }
        attrs.put(_OSGI_WEBRESOURCE, npmName);
        attrs.put("version:Version", analyzer.getBundleVersion());
        parameters.add(_OSGI_WEBRESOURCE, attrs);
        this.setCapabilities(analyzer, "Provide-Capability", parameters);
        return npmModule;
    }

    protected void setCapabilities(Analyzer analyzer, String capabilityType, Parameters parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Parameters headerParameters = new Parameters(analyzer.getProperty(capabilityType));
        if (!headerParameters.isEmpty()) {
            parameters.mergeWith(headerParameters, false);
        }
        analyzer.setProperty(capabilityType, parameters.toString());
    }

    protected String toVersion(String major, String minor, String micro, String qualifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(major);
        if (minor == null || minor.equalsIgnoreCase("x") || minor.equals("*")) {
            sb.append(".0");
        } else {
            sb.append(".");
            sb.append(minor);
        }
        if (micro == null || micro.equalsIgnoreCase("x") || micro.equals("*")) {
            sb.append(".0");
        } else {
            sb.append(".");
            sb.append(micro);
        }
        if (qualifier == null) {
            sb.append("");
        } else {
            sb.append(".");
            sb.append(qualifier);
        }
        return sb.toString();
    }

    public static class NpmModule {
        public Map<String, String> dependencies;
        public String name;
        public Map<String, String> runtime;
        public String version;
    }
}

