/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.impl;

import com.liferay.ibm.icu.impl.CalendarData;
import com.liferay.ibm.icu.impl.ICUResourceBundle;
import com.liferay.ibm.icu.text.DateFormat;
import com.liferay.ibm.icu.text.MessageFormat;
import com.liferay.ibm.icu.util.Calendar;
import com.liferay.ibm.icu.util.TimeZone;
import com.liferay.ibm.icu.util.ULocale;
import com.liferay.ibm.icu.util.UResourceBundle;
import com.liferay.ibm.icu.util.UResourceBundleIterator;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.TreeSet;

public class RelativeDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1131984966440549435L;
    private DateFormat fDateFormat;
    private DateFormat fTimeFormat;
    private MessageFormat fCombinedFormat;
    int fDateStyle;
    int fTimeStyle;
    ULocale fLocale;
    private transient URelativeString[] fDates = null;

    public RelativeDateFormat(int timeStyle, int dateStyle, ULocale locale) {
        int newStyle;
        this.fLocale = locale;
        this.fTimeStyle = timeStyle;
        this.fDateStyle = dateStyle;
        if (this.fDateStyle != -1) {
            newStyle = this.fDateStyle & 0xFFFFFF7F;
            this.fDateFormat = DateFormat.getDateInstance(newStyle, locale);
        } else {
            this.fDateFormat = null;
        }
        if (this.fTimeStyle != -1) {
            newStyle = this.fTimeStyle & 0xFFFFFF7F;
            this.fTimeFormat = DateFormat.getTimeInstance(newStyle, locale);
        } else {
            this.fTimeFormat = null;
        }
        this.initializeCalendar(null, this.fLocale);
        this.loadDates();
        this.initializeCombinedFormat(this.calendar, this.fLocale);
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        int dayDiff;
        String dayString = null;
        String timeString = null;
        if (this.fDateStyle != -1 && (dayString = this.getStringForDay(dayDiff = RelativeDateFormat.dayDifference(cal))) == null) {
            dayString = this.fDateFormat.format(cal);
        }
        if (this.fTimeStyle != -1) {
            timeString = this.fTimeFormat.format(cal);
        }
        if (dayString != null && timeString != null) {
            return this.fCombinedFormat.format(new Object[]{dayString, timeString}, toAppendTo, new FieldPosition(0));
        }
        if (dayString != null) {
            toAppendTo.append(dayString);
        } else if (timeString != null) {
            toAppendTo.append(timeString);
        }
        return toAppendTo;
    }

    public void parse(String text, Calendar cal, ParsePosition pos) {
        throw new UnsupportedOperationException("Relative Date parse is not implemented yet");
    }

    private String getStringForDay(int day) {
        if (this.fDates == null) {
            this.loadDates();
        }
        for (int i = 0; i < this.fDates.length; ++i) {
            if (this.fDates[i].offset != day) continue;
            return this.fDates[i].string;
        }
        return null;
    }

    private synchronized void loadDates() {
        CalendarData calData = new CalendarData(this.fLocale, this.calendar.getType());
        ICUResourceBundle rb = calData.get("fields", "day", "relative");
        TreeSet<URelativeString> datesSet = new TreeSet<URelativeString>(new Comparator(){

            public int compare(Object o1, Object o2) {
                URelativeString r1 = (URelativeString)o1;
                URelativeString r2 = (URelativeString)o2;
                if (r1.offset == r2.offset) {
                    return 0;
                }
                if (r1.offset < r2.offset) {
                    return -1;
                }
                return 1;
            }
        });
        UResourceBundleIterator i = rb.getIterator();
        while (i.hasNext()) {
            UResourceBundle line = i.next();
            String k = line.getKey();
            String v = line.getString();
            URelativeString rs = new URelativeString(k, v);
            datesSet.add(rs);
        }
        this.fDates = new URelativeString[0];
        this.fDates = datesSet.toArray(this.fDates);
    }

    private static int dayDifference(Calendar until) {
        Calendar nowCal = (Calendar)until.clone();
        Date nowDate = new Date(System.currentTimeMillis());
        nowCal.clear();
        nowCal.setTime(nowDate);
        int dayDiff = until.get(20) - nowCal.get(20);
        return dayDiff;
    }

    private Calendar initializeCalendar(TimeZone zone, ULocale locale) {
        if (this.calendar == null) {
            this.calendar = zone == null ? Calendar.getInstance(locale) : Calendar.getInstance(zone, locale);
        }
        return this.calendar;
    }

    private MessageFormat initializeCombinedFormat(Calendar cal, ULocale locale) {
        String pattern = "{1} {0}";
        try {
            CalendarData calData = new CalendarData(locale, cal.getType());
            String[] patterns = calData.get("DateTimePatterns").getStringArray();
            if (patterns != null && patterns.length >= 9) {
                pattern = patterns[8];
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.fCombinedFormat = new MessageFormat(pattern, locale);
        return this.fCombinedFormat;
    }

    public class URelativeString {
        public int offset;
        public String string;

        URelativeString(int offset, String string) {
            this.offset = offset;
            this.string = string;
        }

        URelativeString(String offset, String string) {
            this.offset = Integer.parseInt(offset);
            this.string = string;
        }
    }
}

