/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.BaseIndexWriter;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.logging.ElasticsearchExceptionHandler;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={IndexWriter.class})
public class ElasticsearchIndexWriter
extends BaseIndexWriter {
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexWriter.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private SpellCheckIndexWriter _spellCheckIndexWriter;

    public void addDocument(SearchContext searchContext, Document document) {
        for (String indexName : this._getIndexNames(searchContext)) {
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
            indexDocumentRequest.setType("_doc");
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                indexDocumentRequest.setRefresh(true);
            }
            try {
                this._searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
            }
            catch (RuntimeException runtimeException) {
                if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                    _log.error((Throwable)runtimeException);
                    continue;
                }
                throw runtimeException;
            }
        }
    }

    public void addDocuments(SearchContext searchContext, Collection<Document> documents) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        for (String indexName : this._getIndexNames(searchContext)) {
            documents.forEach(document -> {
                IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
                indexDocumentRequest.setType("_doc");
                bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
            });
        }
        BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        if (bulkDocumentResponse.hasErrors()) {
            if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                _log.error((Object)"Bulk add failed");
            } else {
                throw new SystemException("Bulk add failed");
            }
        }
    }

    public void commit(SearchContext searchContext) {
        for (String indexName : this._getIndexNames(searchContext)) {
            RefreshIndexRequest refreshIndexRequest = new RefreshIndexRequest(new String[]{indexName});
            try {
                this._searchEngineAdapter.execute((IndexRequest)refreshIndexRequest);
            }
            catch (RuntimeException runtimeException) {
                if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                    _log.error((Throwable)runtimeException);
                    continue;
                }
                throw runtimeException;
            }
        }
    }

    public void deleteDocument(SearchContext searchContext, String uid) {
        for (String indexName : this._getIndexNames(searchContext)) {
            DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, uid);
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteDocumentRequest.setRefresh(true);
            }
            deleteDocumentRequest.setType("_doc");
            try {
                this._searchEngineAdapter.execute((DocumentRequest)deleteDocumentRequest);
            }
            catch (RuntimeException runtimeException) {
                ElasticsearchExceptionHandler elasticsearchExceptionHandler = new ElasticsearchExceptionHandler(_log, this._elasticsearchConfigurationWrapper.logExceptionsOnly());
                elasticsearchExceptionHandler.handleDeleteDocumentException(runtimeException);
            }
        }
    }

    public void deleteDocuments(SearchContext searchContext, Collection<String> uids) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        for (String indexName : this._getIndexNames(searchContext)) {
            uids.forEach(uid -> {
                DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, uid);
                deleteDocumentRequest.setType("_doc");
                bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
            });
        }
        BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        if (bulkDocumentResponse.hasErrors()) {
            if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                _log.error((Object)"Bulk delete failed");
            } else {
                throw new SystemException("Bulk delete failed");
            }
        }
    }

    public void deleteEntityDocuments(SearchContext searchContext, String className) {
        for (String indexName : this._getIndexNames(searchContext)) {
            try {
                BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
                booleanQuery.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
                BooleanFilter booleanFilter = new BooleanFilter();
                booleanFilter.add((Filter)new TermFilter("entryClassName", className), BooleanClauseOccur.MUST);
                booleanQuery.setPreBooleanFilter(booleanFilter);
                DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)booleanQuery, new String[]{indexName});
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    deleteByQueryDocumentRequest.setRefresh(true);
                }
                this._searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
            catch (RuntimeException runtimeException) {
                if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                    _log.error((Throwable)runtimeException);
                    continue;
                }
                throw runtimeException;
            }
        }
    }

    public void partiallyUpdateDocument(SearchContext searchContext, Document document) {
        for (String indexName : this._getIndexNames(searchContext)) {
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(indexName, document.getUID(), document);
            updateDocumentRequest.setType("_doc");
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                updateDocumentRequest.setRefresh(true);
            }
            updateDocumentRequest.setUpsert(true);
            try {
                this._searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
            }
            catch (RuntimeException runtimeException) {
                if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                    _log.error((Throwable)runtimeException);
                    continue;
                }
                throw runtimeException;
            }
        }
    }

    public void partiallyUpdateDocuments(SearchContext searchContext, Collection<Document> documents) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        for (String indexName : this._getIndexNames(searchContext)) {
            documents.forEach(document -> {
                UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(indexName, document.getUID(), document);
                updateDocumentRequest.setType("_doc");
                bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)updateDocumentRequest);
            });
        }
        BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        if (bulkDocumentResponse.hasErrors()) {
            if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                _log.error((Object)"Bulk partial update failed");
            } else {
                throw new SystemException("Bulk partial update failed");
            }
        }
    }

    public void updateDocument(SearchContext searchContext, Document document) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        for (String indexName : this._getIndexNames(searchContext)) {
            DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, document.getUID());
            deleteDocumentRequest.setType("_doc");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
            indexDocumentRequest.setType("_doc");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
        }
        BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        if (bulkDocumentResponse.hasErrors()) {
            if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                _log.error((Object)"Update failed");
            } else {
                throw new SystemException("Update failed");
            }
        }
    }

    public void updateDocuments(SearchContext searchContext, Collection<Document> documents) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        for (String indexName : this._getIndexNames(searchContext)) {
            documents.forEach(document -> {
                DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, document.getUID());
                deleteDocumentRequest.setType("_doc");
                bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
                IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
                indexDocumentRequest.setType("_doc");
                bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
            });
        }
        BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        if (bulkDocumentResponse.hasErrors()) {
            if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                _log.error((Object)"Bulk update failed");
            } else {
                throw new SystemException("Bulk update failed");
            }
        }
    }

    protected SpellCheckIndexWriter getSpellCheckIndexWriter() {
        return this._spellCheckIndexWriter;
    }

    private String _getIndexNameNext(long companyId) {
        Company company = this._companyLocalService.fetchCompany(companyId);
        if (company == null) {
            return null;
        }
        String indexNameNext = company.getIndexNameNext();
        if (Validator.isBlank((String)indexNameNext)) {
            return null;
        }
        return indexNameNext;
    }

    private Set<String> _getIndexNames(SearchContext searchContext) {
        HashSet<String> indexNames = new HashSet<String>();
        String indexNameCurrent = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
        indexNames.add(indexNameCurrent);
        String indexNameNext = this._getIndexNameNext(searchContext.getCompanyId());
        if (indexNameNext != null) {
            indexNames.add(indexNameNext);
        }
        return indexNames;
    }
}

