/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.search.ccr.CrossClusterReplicationHelper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.engine.ConnectionInformation;
import com.liferay.portal.search.engine.NodeInformation;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.cluster.ClusterHealthStatus;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import com.liferay.portal.search.engine.adapter.index.CloseIndexRequest;
import com.liferay.portal.search.engine.adapter.index.CloseIndexResponse;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotResponse;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesResponse;
import com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotState;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.client.ClusterClient;
import org.elasticsearch.client.IngestClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={SearchEngine.class})
public class ElasticsearchSearchEngine
implements ElasticsearchConfigurationObserver,
SearchEngine {
    private static final String _BACKUP_REPOSITORY_NAME = "liferay_backup";
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngine.class);
    private static final Snapshot<CrossClusterReplicationHelper> _crossClusterReplicationHelperSnapshot = new Snapshot(ElasticsearchSearchEngine.class, CrossClusterReplicationHelper.class, null, true);
    @Reference
    private ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    @Reference
    private IndexFactory _indexFactory;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private IndexSearcher _indexSearcher;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private IndexWriter _indexWriter;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private SearchEngineInformation _searchEngineInformation;

    public synchronized String backup(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this._validateBackupName(backupName);
        this.createBackupRepository();
        CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        createSnapshotRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this._searchEngineAdapter.execute((SnapshotRequest)createSnapshotRequest);
        SnapshotDetails snapshotDetails = createSnapshotResponse.getSnapshotDetails();
        SnapshotState snapshotState = snapshotDetails.getSnapshotState();
        if (snapshotState.equals((Object)SnapshotState.FAILED)) {
            throw new IllegalStateException("Unable to complete snapshot");
        }
        return backupName;
    }

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this._elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    public void createBackupRepository() {
        if (this._hasBackupRepository()) {
            return;
        }
        CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest = new CreateSnapshotRepositoryRequest(_BACKUP_REPOSITORY_NAME, "es_backup");
        this._searchEngineAdapter.execute((SnapshotRequest)createSnapshotRepositoryRequest);
    }

    public IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    public IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    @Override
    public int getPriority() {
        return 4;
    }

    public String getVendor() {
        return "Elasticsearch";
    }

    public void initialize(long companyId) {
        CrossClusterReplicationHelper crossClusterReplicationHelper;
        this._waitForYellowStatus();
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        boolean created = this._indexFactory.initializeIndex(restHighLevelClient.indices(), companyId);
        this._indexFactory.registerCompanyId(companyId);
        if (created) {
            this._waitForYellowStatus();
        }
        if ((crossClusterReplicationHelper = (CrossClusterReplicationHelper)_crossClusterReplicationHelperSnapshot.get()) != null) {
            crossClusterReplicationHelper.follow(this._indexNameBuilder.getIndexName(companyId));
        }
    }

    public boolean meetsMinimumVersionRequirement(Version minimumVersion, String versionString) {
        return minimumVersion.compareTo(Version.parseVersion((String)versionString)) <= 0;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this._putTimestampPipeline();
    }

    public synchronized void removeBackup(long companyId, String backupName) {
        if (!this._hasBackupRepository()) {
            return;
        }
        DeleteSnapshotRequest deleteSnapshotRequest = new DeleteSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        this._searchEngineAdapter.execute((SnapshotRequest)deleteSnapshotRequest);
    }

    public void removeCompany(long companyId) {
        block3: {
            CrossClusterReplicationHelper crossClusterReplicationHelper = (CrossClusterReplicationHelper)_crossClusterReplicationHelperSnapshot.get();
            if (crossClusterReplicationHelper != null) {
                crossClusterReplicationHelper.unfollow(this._indexNameBuilder.getIndexName(companyId));
            }
            this.setAutoCreateIndex(false);
            try {
                RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
                this._indexFactory.deleteIndex(restHighLevelClient.indices(), companyId);
                this._indexFactory.unregisterCompanyId(companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to delete index for " + companyId), (Throwable)exception);
            }
        }
    }

    public synchronized void restore(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this._validateBackupName(backupName);
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        CloseIndexResponse closeIndexResponse = (CloseIndexResponse)this._searchEngineAdapter.execute((IndexRequest)closeIndexRequest);
        if (!closeIndexResponse.isAcknowledged()) {
            throw new SystemException("Error closing index: " + this._indexNameBuilder.getIndexName(companyId));
        }
        RestoreSnapshotRequest restoreSnapshotRequest = new RestoreSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        restoreSnapshotRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        this._searchEngineAdapter.execute((SnapshotRequest)restoreSnapshotRequest);
        this._waitForYellowStatus();
    }

    public void setAutoCreateIndex(boolean enable) {
        if (Validator.isBlank((String)this._indexNameBuilder.getIndexNamePrefix())) {
            return;
        }
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        ClusterClient clusterClient = restHighLevelClient.cluster();
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.persistentSettings(Settings.builder().put("action.auto_create_index", this._createAutoCreateIndexSetting(enable)));
        try {
            clusterClient.putSettings(clusterUpdateSettingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfigurationWrapper.register(this);
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)ElasticsearchSearchEngine.class.getClassLoader());){
            this._checkNodeVersions();
            this.setAutoCreateIndex(false);
            if (StartupHelperUtil.isDBNew()) {
                for (long companyId : this._getIndexedCompanyIds()) {
                    this.removeCompany(companyId);
                }
            }
            this._putTimestampPipeline();
            this.initialize(0L);
        }
    }

    private void _checkNodeVersions() {
        if (!this._elasticsearchConfigurationWrapper.productionModeEnabled()) {
            return;
        }
        String minimumVersionString = this._elasticsearchConfigurationWrapper.minimumRequiredNodeVersion();
        if (minimumVersionString.equals("0.0.0")) {
            String clientVersion = this._searchEngineInformation.getClientVersionString();
            minimumVersionString = clientVersion.substring(0, clientVersion.lastIndexOf("."));
        }
        Version minimumVersion = Version.parseVersion((String)minimumVersionString);
        List connectionInformationList = this._searchEngineInformation.getConnectionInformationList();
        for (ConnectionInformation connectionInformation : connectionInformationList) {
            List nodeInformationList = connectionInformation.getNodeInformationList();
            for (NodeInformation nodeInformation : nodeInformationList) {
                if (this.meetsMinimumVersionRequirement(minimumVersion, nodeInformation.getVersion())) continue;
                _log.error((Object)StringBundler.concat((String[])new String[]{"Elasticsearch node ", nodeInformation.getName(), " does not meet the minimum version requirement ", "of ", minimumVersionString}));
                System.exit(1);
            }
        }
    }

    private String _createAutoCreateIndexSetting(boolean enable) {
        String currentValue = this._getAutoCreateIndexSetting();
        String disableAutoCreateLiferayIndexPattern = StringBundler.concat((String[])new String[]{"-", this._indexNameBuilder.getIndexNamePrefix(), "*"});
        String enableAutoCreateLiferayIndexPattern = StringBundler.concat((String[])new String[]{"+", this._indexNameBuilder.getIndexNamePrefix(), "*"});
        if (enable) {
            if (Validator.isBlank((String)currentValue) || currentValue.equals("*") || StringUtil.equalsIgnoreCase((String)currentValue, (String)"true") || currentValue.contains(enableAutoCreateLiferayIndexPattern)) {
                return currentValue;
            }
            if (StringUtil.equalsIgnoreCase((String)currentValue, (String)"false")) {
                return enableAutoCreateLiferayIndexPattern;
            }
            if (currentValue.contains(disableAutoCreateLiferayIndexPattern)) {
                return StringUtil.replace((String)currentValue, (String)disableAutoCreateLiferayIndexPattern, (String)enableAutoCreateLiferayIndexPattern);
            }
            return StringBundler.concat((String[])new String[]{enableAutoCreateLiferayIndexPattern, ", ", currentValue});
        }
        if (Validator.isBlank((String)currentValue) || currentValue.equals("*") || StringUtil.equalsIgnoreCase((String)currentValue, (String)"true")) {
            return StringBundler.concat((String[])new String[]{disableAutoCreateLiferayIndexPattern, ", ", "*"});
        }
        if (StringUtil.equalsIgnoreCase((String)currentValue, (String)"false") || currentValue.contains(disableAutoCreateLiferayIndexPattern)) {
            return currentValue;
        }
        if (currentValue.contains(enableAutoCreateLiferayIndexPattern)) {
            return StringUtil.replace((String)currentValue, (String)enableAutoCreateLiferayIndexPattern, (String)disableAutoCreateLiferayIndexPattern);
        }
        return StringBundler.concat((String[])new String[]{disableAutoCreateLiferayIndexPattern, ", ", currentValue});
    }

    private String _getAutoCreateIndexSetting() {
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        ClusterClient clusterClient = restHighLevelClient.cluster();
        try {
            ClusterGetSettingsResponse clusterGetSettingsResponse = clusterClient.getSettings(new ClusterGetSettingsRequest(), RequestOptions.DEFAULT);
            Settings settings = clusterGetSettingsResponse.getPersistentSettings();
            return settings.get("action.auto_create_index");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private Collection<Long> _getIndexedCompanyIds() {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        String firstIndexName = this._indexNameBuilder.getIndexName(0L);
        String prefix = firstIndexName.substring(0, firstIndexName.length() - 1);
        GetIndexIndexResponse getIndexIndexResponse = (GetIndexIndexResponse)this._searchEngineAdapter.execute((IndexRequest)new GetIndexIndexRequest(prefix + "*"));
        for (String indexName : getIndexIndexResponse.getIndexNames()) {
            long companyId = GetterUtil.getLong((String)StringUtil.removeSubstring((String)indexName, (String)prefix));
            if (companyId == 0L) continue;
            companyIds.add(companyId);
        }
        return companyIds;
    }

    private boolean _hasBackupRepository() {
        GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest = new GetSnapshotRepositoriesRequest(new String[]{_BACKUP_REPOSITORY_NAME});
        GetSnapshotRepositoriesResponse getSnapshotRepositoriesResponse = (GetSnapshotRepositoriesResponse)this._searchEngineAdapter.execute((SnapshotRequest)getSnapshotRepositoriesRequest);
        List snapshotRepositoryDetailsList = getSnapshotRepositoriesResponse.getSnapshotRepositoryDetails();
        return !snapshotRepositoryDetailsList.isEmpty();
    }

    private void _putTimestampPipeline() {
        String source = JSONUtil.put((String)"description", (Object)"Adds timestamp to documents").put("processors", JSONUtil.put((Object)JSONUtil.put((String)"set", (Object)JSONUtil.put((String)"field", (Object)"_source.timestamp").put("value", "{{{_ingest.timestamp}}}")))).toString();
        PutPipelineRequest putPipelineRequest = new PutPipelineRequest("timestamp", (BytesReference)new BytesArray(source.getBytes(StandardCharsets.UTF_8)), XContentType.JSON);
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        IngestClient ingestClient = restHighLevelClient.ingest();
        try {
            ingestClient.putPipeline(putPipelineRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to put timestamp pipeline", (Throwable)ioException);
        }
    }

    private void _validateBackupName(String backupName) throws SearchException {
        if (Validator.isNull((String)backupName)) {
            throw new SearchException("Backup name must not be an empty string");
        }
        if (StringUtil.contains((String)backupName, (String)",")) {
            throw new SearchException("Backup name must not contain comma");
        }
        if (StringUtil.startsWith((String)backupName, (String)"-")) {
            throw new SearchException("Backup name must not start with dash");
        }
        if (StringUtil.contains((String)backupName, (String)"#")) {
            throw new SearchException("Backup name must not contain pounds");
        }
        if (StringUtil.contains((String)backupName, (String)" ")) {
            throw new SearchException("Backup name must not contain spaces");
        }
        if (StringUtil.contains((String)backupName, (String)"\t")) {
            throw new SearchException("Backup name must not contain tabs");
        }
        for (char c : backupName.toCharArray()) {
            if (!Strings.INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            throw new SearchException("Backup name must not contain invalid file name characters");
        }
    }

    private void _waitForYellowStatus() {
        long timeout = 30000L;
        if (PortalRunMode.isTestMode()) {
            timeout = 3600000L;
        }
        HealthClusterRequest healthClusterRequest = new HealthClusterRequest();
        healthClusterRequest.setTimeout(timeout);
        healthClusterRequest.setWaitForClusterHealthStatus(ClusterHealthStatus.YELLOW);
        HealthClusterResponse healthClusterResponse = (HealthClusterResponse)this._searchEngineAdapter.execute((ClusterRequest)healthClusterRequest);
        if (healthClusterResponse.getClusterHealthStatus() == ClusterHealthStatus.RED) {
            throw new IllegalStateException("Unable to initialize Elasticsearch cluster: " + healthClusterResponse);
        }
    }
}

