/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.BaseAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket.FiltersAggregationTranslator;
import com.liferay.portal.search.query.QueryTranslator;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FiltersAggregationTranslator.class})
public class FiltersAggregationTranslatorImpl
implements FiltersAggregationTranslator {
    private final BaseAggregationTranslator _baseAggregationTranslator = new BaseAggregationTranslator();
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private QueryTranslator<QueryBuilder> _queryTranslator;

    @Override
    public FiltersAggregationBuilder translate(FiltersAggregation filtersAggregation, AggregationTranslator<AggregationBuilder> aggregationTranslator, PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        List keyedQueries = filtersAggregation.getKeyedQueries();
        ArrayList keyedFilters = new ArrayList(keyedQueries.size());
        keyedQueries.forEach(keyedQuery -> {
            QueryBuilder filterQueryBuilder = (QueryBuilder)this._queryTranslator.translate(keyedQuery.getQuery());
            keyedFilters.add(new FiltersAggregator.KeyedFilter(keyedQuery.getKey(), filterQueryBuilder));
        });
        FiltersAggregationBuilder filtersAggregationBuilder = AggregationBuilders.filters((String)filtersAggregation.getName(), (FiltersAggregator.KeyedFilter[])keyedFilters.toArray(new FiltersAggregator.KeyedFilter[keyedQueries.size()]));
        if (filtersAggregation.getOtherBucket() != null) {
            filtersAggregationBuilder.otherBucket(filtersAggregation.getOtherBucket().booleanValue());
        }
        if (filtersAggregation.getOtherBucketKey() != null) {
            filtersAggregationBuilder.otherBucketKey(filtersAggregation.getOtherBucketKey());
        }
        this._baseAggregationTranslator.translate((AggregationBuilder)filtersAggregationBuilder, (Aggregation)filtersAggregation, aggregationTranslator, pipelineAggregationTranslator);
        return filtersAggregationBuilder;
    }
}

