/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.FieldAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.BaseFieldAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket.HistogramAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket.OrderTranslator;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={HistogramAggregationTranslator.class})
public class HistogramAggregationTranslatorImpl
implements HistogramAggregationTranslator {
    private final BaseFieldAggregationTranslator _baseFieldAggregationTranslator = new BaseFieldAggregationTranslator();
    private final OrderTranslator _orderTranslator = new OrderTranslator();

    @Override
    public HistogramAggregationBuilder translate(HistogramAggregation histogramAggregation, AggregationTranslator<AggregationBuilder> aggregationTranslator, PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        HistogramAggregationBuilder histogramAggregationBuilder = this._baseFieldAggregationTranslator.translate(baseMetricsAggregation -> AggregationBuilders.histogram((String)baseMetricsAggregation.getName()), (FieldAggregation)histogramAggregation, aggregationTranslator, pipelineAggregationTranslator);
        if (ListUtil.isNotEmpty((List)histogramAggregation.getOrders())) {
            List<BucketOrder> bucketOrders = this._orderTranslator.translate(histogramAggregation.getOrders());
            histogramAggregationBuilder.order(bucketOrders);
        }
        if (histogramAggregation.getMaxBound() != null && histogramAggregation.getMinBound() != null) {
            histogramAggregationBuilder.extendedBounds(histogramAggregation.getMinBound().doubleValue(), histogramAggregation.getMaxBound().doubleValue());
        }
        if (histogramAggregation.getMinDocCount() != null) {
            histogramAggregationBuilder.minDocCount(histogramAggregation.getMinDocCount().longValue());
        }
        if (histogramAggregation.getInterval() != null) {
            histogramAggregationBuilder.interval(histogramAggregation.getInterval().doubleValue());
        }
        if (histogramAggregation.getOffset() != null) {
            histogramAggregationBuilder.offset(histogramAggregation.getOffset().doubleValue());
        }
        return histogramAggregationBuilder;
    }
}

