/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.cluster;

import com.liferay.portal.search.cluster.StatsInformation;
import com.liferay.portal.search.cluster.StatsInformationFactory;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.StatsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.StatsIndexResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatsInformationFactory.class})
public class ElasticsearchStatsInformationFactory
implements StatsInformationFactory {
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;

    public StatsInformation getStatsInformation() {
        return this.getStatsInformation(null, null);
    }

    public StatsInformation getStatsInformation(String[] nodeIds, String[] indexNames) {
        StatsClusterResponse statsClusterResponse = (StatsClusterResponse)this._searchEngineAdapter.execute((ClusterRequest)new StatsClusterRequest(nodeIds));
        StatsIndexResponse statsIndexResponse = (StatsIndexResponse)this._searchEngineAdapter.execute((IndexRequest)new StatsIndexRequest(indexNames));
        return new StatsInformationImpl(statsClusterResponse.getAvailableSpaceInBytes(), statsIndexResponse.getSizeOfLargestIndexInBytes(), statsClusterResponse.getUsedSpaceInBytes());
    }

    private class StatsInformationImpl
    implements StatsInformation {
        private final double _availableDiskSpace;
        private final double _sizeOfLargestIndex;
        private final double _usedDiskSpace;

        public StatsInformationImpl(long availableSpaceInBytes, long sizeOfLargestIndexInBytes, long usedSpaceInBytes) {
            this._availableDiskSpace = this._convertToGigabytes(availableSpaceInBytes);
            this._sizeOfLargestIndex = this._convertToGigabytes(sizeOfLargestIndexInBytes);
            this._usedDiskSpace = this._convertToGigabytes(usedSpaceInBytes);
        }

        public double getAvailableDiskSpace() {
            return this._availableDiskSpace;
        }

        public double getSizeOfLargestIndex() {
            return this._sizeOfLargestIndex;
        }

        public double getUsedDiskSpace() {
            return this._usedDiskSpace;
        }

        private double _convertToGigabytes(long value) {
            return (double)value / 1.073741824E9;
        }
    }
}

