/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.configuration.admin.definition;

import com.liferay.configuration.admin.definition.ConfigurationFieldOptionsProvider;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"configuration.field.name=remoteClusterConnectionId", "configuration.pid=com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration"}, service={ConfigurationFieldOptionsProvider.class})
public class ConnectionIdConfigurationFieldOptionsProvider
implements ConfigurationFieldOptionsProvider {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    public List<ConfigurationFieldOptionsProvider.Option> getOptions() {
        ArrayList<ConfigurationFieldOptionsProvider.Option> options = new ArrayList<ConfigurationFieldOptionsProvider.Option>();
        for (ElasticsearchConnection elasticsearchConnection : this.elasticsearchConnectionManager.getElasticsearchConnections()) {
            final String connectionId = elasticsearchConnection.getConnectionId();
            if (connectionId.equals("__REMOTE__") || connectionId.equals("__SIDECAR__") || !elasticsearchConnection.isActive()) continue;
            ConfigurationFieldOptionsProvider.Option option = new ConfigurationFieldOptionsProvider.Option(){

                public String getLabel(Locale locale) {
                    return connectionId;
                }

                public String getValue() {
                    return connectionId;
                }
            };
            options.add(option);
        }
        return options;
    }
}

