/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConnectionConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConnectionConfiguration"}, service={ConfigurationModelListener.class})
public class ElasticsearchConnectionConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnectionConfigurationModelListener.class);

    public void onBeforeDelete(String pid) throws ConfigurationModelListenerException {
        try {
            this.elasticsearchConnectionManager.removeElasticsearchConnection(this._getConnectionId(pid));
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), ElasticsearchConnectionConfiguration.class, this.getClass(), null);
        }
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            String connectionId = StringUtil.unquote((String)((String)properties.get("connectionId")));
            this._validateUniqueConnectionId(pid, connectionId);
            this._validateNetworkHostAddresses(properties);
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), ElasticsearchConnectionConfiguration.class, this.getClass(), properties);
        }
    }

    private String _getConnectionId(String pid) throws Exception {
        Configuration configuration = this.configurationAdmin.getConfiguration(pid, "?");
        Dictionary properties = configuration.getProperties();
        if (properties != null) {
            return StringUtil.unquote((String)((String)properties.get("connectionId")));
        }
        return null;
    }

    private String _getMessage(String key, Object ... arguments) {
        try {
            return ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)key, (Object[])arguments);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }

    private void _validateNetworkHostAddresses(Dictionary<String, Object> properties) throws Exception {
        String[] networkHostAddresses;
        for (String networkHostAddress : networkHostAddresses = GetterUtil.getStringValues((Object)properties.get("networkHostAddresses"))) {
            if (Validator.isBlank((String)networkHostAddress)) continue;
            return;
        }
        _log.error((Object)"Unable to validate network host addresses");
        throw new Exception(this._getMessage("please-set-at-least-one-network-host-address", new Object[0]));
    }

    private void _validateUniqueConnectionId(String pid, String connectionId) throws Exception {
        if (Validator.isBlank((String)connectionId)) {
            _log.error((Object)"Connection ID is blank");
            throw new Exception(this._getMessage("please-set-a-connection-id", new Object[0]));
        }
        if (connectionId.equals("__REMOTE__") || connectionId.equals("__SIDECAR__")) {
            _log.error((Object)("The ID you entered is reserved: " + connectionId));
            throw new Exception(this._getMessage("the-id-you-entered-is-reserved-x", connectionId));
        }
        String filterString = String.format("(&(service.factoryPid=%s)(connectionId=%s))", ElasticsearchConnectionConfiguration.class.getName(), connectionId);
        Configuration[] configurations = this.configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            String previousConnectionId = this._getConnectionId(pid);
            if (previousConnectionId != null && !previousConnectionId.equals(connectionId)) {
                this.elasticsearchConnectionManager.removeElasticsearchConnection(previousConnectionId);
            }
            return;
        }
        Configuration configuration = configurations[0];
        if (pid.equals(configuration.getPid())) {
            return;
        }
        _log.error((Object)("There is already a connection with the ID: " + connectionId));
        throw new Exception(this._getMessage("there-is-already-a-connection-with-the-id-x", connectionId));
    }
}

