/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.concurrent.SystemExecutorServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.ccr.CrossClusterReplicationConfigurationHelper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionBuilder;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionNotInitializedException;
import com.liferay.portal.search.elasticsearch7.internal.connection.ProxyConfig;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ElasticsearchClientResolver.class, ElasticsearchConnectionManager.class})
public class ElasticsearchConnectionManager
implements ElasticsearchClientResolver,
ElasticsearchConfigurationObserver {
    @Reference
    protected ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected Http http;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnectionManager.class);
    private static final Snapshot<CrossClusterReplicationConfigurationHelper> _crossClusterReplicationConfigurationHelperSnapshot = new Snapshot(ElasticsearchConnectionManager.class, CrossClusterReplicationConfigurationHelper.class, null, true);
    private final Map<String, Supplier<ElasticsearchConnection>> _elasticsearchConnectionSuppliers = new ConcurrentHashMap<String, Supplier<ElasticsearchConnection>>();
    private volatile InetSocketAddress _portalInetSocketAddress;
    private ServiceRegistration<?> _serviceRegistration;

    public void addElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        Supplier<ElasticsearchConnection> elasticsearchConnectionSupplier;
        String connectionId = elasticsearchConnection.getConnectionId();
        if (connectionId == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skipping connection because connection ID is null");
            }
            return;
        }
        if (elasticsearchConnection.isActive()) {
            FutureTask<ElasticsearchConnection> futureTask = new FutureTask<ElasticsearchConnection>(() -> {
                try {
                    elasticsearchConnection.connect();
                }
                catch (RuntimeException runtimeException) {
                    if (connectionId.equals("__SIDECAR__")) {
                        _log.error((Object)StringBundler.concat((String[])new String[]{"Elasticsearch sidecar could not be ", "started. Search will be unavailable. ", "Manual installation of Elasticsearch and ", "activation of remote mode is ", "recommended."}), (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
                return elasticsearchConnection;
            });
            ExecutorService executorService = SystemExecutorServiceUtil.getExecutorService();
            executorService.submit(futureTask);
            elasticsearchConnectionSupplier = () -> {
                try {
                    return (ElasticsearchConnection)futureTask.get();
                }
                catch (Exception exception) {
                    return (ElasticsearchConnection)ReflectionUtil.throwException((Throwable)exception);
                }
            };
        } else {
            elasticsearchConnectionSupplier = () -> elasticsearchConnection;
        }
        this._elasticsearchConnectionSuppliers.put(connectionId, elasticsearchConnectionSupplier);
    }

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this.elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this.getElasticsearchConnection(null, false);
    }

    public ElasticsearchConnection getElasticsearchConnection(boolean preferLocalCluster) {
        return this.getElasticsearchConnection(null, preferLocalCluster);
    }

    public ElasticsearchConnection getElasticsearchConnection(String connectionId) {
        Supplier<ElasticsearchConnection> elasticsearchConnectionSupplier = this._elasticsearchConnectionSuppliers.get(connectionId);
        if (_log.isInfoEnabled()) {
            if (elasticsearchConnectionSupplier != null) {
                _log.info((Object)("Returning connection with ID: " + connectionId));
            } else {
                _log.info((Object)("Connection not found. Returning null for ID: " + connectionId));
            }
        }
        if (elasticsearchConnectionSupplier == null) {
            return null;
        }
        return elasticsearchConnectionSupplier.get();
    }

    public Collection<ElasticsearchConnection> getElasticsearchConnections() {
        ArrayList<ElasticsearchConnection> elasticsearchConnections = new ArrayList<ElasticsearchConnection>();
        for (Supplier<ElasticsearchConnection> supplier : this._elasticsearchConnectionSuppliers.values()) {
            elasticsearchConnections.add(supplier.get());
        }
        return elasticsearchConnections;
    }

    public String getLocalClusterConnectionId() {
        InetSocketAddress portalInetSocketAddress = this._portalInetSocketAddress;
        CrossClusterReplicationConfigurationHelper currentCrossClusterReplicationConfigurationHelper = (CrossClusterReplicationConfigurationHelper)_crossClusterReplicationConfigurationHelperSnapshot.get();
        if (portalInetSocketAddress == null) {
            if (currentCrossClusterReplicationConfigurationHelper == null) {
                return null;
            }
            List localClusterConnectionIds = currentCrossClusterReplicationConfigurationHelper.getLocalClusterConnectionIds();
            if (localClusterConnectionIds.isEmpty()) {
                return null;
            }
            return (String)localClusterConnectionIds.get(0);
        }
        Map localClusterConnectionConfigurations = currentCrossClusterReplicationConfigurationHelper.getLocalClusterConnectionIdsMap();
        String localClusterNodeHostName = portalInetSocketAddress.getHostName() + ":" + portalInetSocketAddress.getPort();
        return (String)localClusterConnectionConfigurations.get(localClusterNodeHostName);
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient() {
        return this.getRestHighLevelClient(null);
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient(String connectionId) {
        return this.getRestHighLevelClient(connectionId, false);
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient(String connectionId, boolean preferLocalCluster) {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection(connectionId, preferLocalCluster);
        if (elasticsearchConnection == null) {
            throw new ElasticsearchConnectionNotInitializedException(this._getExceptionMessage("Elasticsearch connection not found.", connectionId, preferLocalCluster));
        }
        RestHighLevelClient restHighLevelClient = elasticsearchConnection.getRestHighLevelClient();
        if (restHighLevelClient == null) {
            throw new ElasticsearchConnectionNotInitializedException(this._getExceptionMessage("REST high level client not found.", elasticsearchConnection.getConnectionId(), preferLocalCluster));
        }
        return restHighLevelClient;
    }

    public boolean isCrossClusterReplicationEnabled() {
        CrossClusterReplicationConfigurationHelper currentCrossClusterReplicationConfigurationHelper = (CrossClusterReplicationConfigurationHelper)_crossClusterReplicationConfigurationHelperSnapshot.get();
        if (currentCrossClusterReplicationConfigurationHelper == null) {
            return false;
        }
        return currentCrossClusterReplicationConfigurationHelper.isCrossClusterReplicationEnabled();
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.applyConfigurations();
    }

    public void removeElasticsearchConnection(String connectionId) {
        if (connectionId == null) {
            return;
        }
        Supplier<ElasticsearchConnection> elasticsearchConnectionSupplier = this._elasticsearchConnectionSuppliers.get(connectionId);
        if (elasticsearchConnectionSupplier == null) {
            return;
        }
        ElasticsearchConnection elasticsearchConnection = elasticsearchConnectionSupplier.get();
        elasticsearchConnection.close();
        this._elasticsearchConnectionSuppliers.remove(connectionId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(PortalInetSocketAddressEventListener.class, (Object)new ElasticsearchPortalInetSocketAddressEventListener(), null);
        this.elasticsearchConfigurationWrapper.register(this);
        this.applyConfigurations();
    }

    protected void applyConfigurations() {
        SearchLogHelperUtil.setRESTClientLoggerLevel(this.elasticsearchConfigurationWrapper.restClientLoggerLevel());
        if (this.elasticsearchConfigurationWrapper.isProductionModeEnabled()) {
            if (Validator.isBlank((String)this.elasticsearchConfigurationWrapper.remoteClusterConnectionId())) {
                this.addElasticsearchConnection(this._createRemoteElasticsearchConnection());
            }
        } else {
            this.removeElasticsearchConnection("__REMOTE__");
        }
    }

    protected ProxyConfig createProxyConfig() {
        ProxyConfig.Builder proxyConfigBuilder = ProxyConfig.builder(this.http);
        return proxyConfigBuilder.networkAddresses(this.elasticsearchConfigurationWrapper.networkHostAddresses()).host(this.elasticsearchConfigurationWrapper.proxyHost()).password(this.elasticsearchConfigurationWrapper.proxyPassword()).port(this.elasticsearchConfigurationWrapper.proxyPort()).userName(this.elasticsearchConfigurationWrapper.proxyHost()).build();
    }

    @Deactivate
    protected void deactivate() {
        this.elasticsearchConfigurationWrapper.unregister(this);
        for (Supplier<ElasticsearchConnection> supplier : this._elasticsearchConnectionSuppliers.values()) {
            ElasticsearchConnection elasticsearchConnection = supplier.get();
            elasticsearchConnection.close();
        }
        this._serviceRegistration.unregister();
    }

    protected ElasticsearchConnection getElasticsearchConnection(String connectionId, boolean preferLocalCluster) {
        String localClusterConnectionId;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Connection requested for ID: " + connectionId));
        }
        if (!Validator.isBlank((String)connectionId)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Getting connection with ID: " + connectionId));
            }
            return this.getElasticsearchConnection(connectionId);
        }
        if (this.elasticsearchConfigurationWrapper.isDevelopmentModeEnabled()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Getting __SIDECAR__ connection");
            }
            return this.getElasticsearchConnection("__SIDECAR__");
        }
        if (preferLocalCluster && this.isCrossClusterReplicationEnabled() && (localClusterConnectionId = this.getLocalClusterConnectionId()) != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Getting local cluster connection with ID: " + localClusterConnectionId));
            }
            return this.getElasticsearchConnection(localClusterConnectionId);
        }
        String remoteClusterConnectionId = this.elasticsearchConfigurationWrapper.remoteClusterConnectionId();
        if (Validator.isBlank((String)remoteClusterConnectionId)) {
            remoteClusterConnectionId = "__REMOTE__";
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Getting remote cluster connection with ID: " + remoteClusterConnectionId));
        }
        return this.getElasticsearchConnection(remoteClusterConnectionId);
    }

    private ElasticsearchConnection _createRemoteElasticsearchConnection() {
        ElasticsearchConnectionBuilder elasticsearchConnectionBuilder = new ElasticsearchConnectionBuilder();
        elasticsearchConnectionBuilder.active(true).authenticationEnabled(this.elasticsearchConfigurationWrapper.authenticationEnabled()).connectionId("__REMOTE__").httpSSLEnabled(this.elasticsearchConfigurationWrapper.httpSSLEnabled()).maxConnections(this.elasticsearchConfigurationWrapper.maxConnections()).maxConnectionsPerRoute(this.elasticsearchConfigurationWrapper.maxConnectionsPerRoute()).networkHostAddresses(this.elasticsearchConfigurationWrapper.networkHostAddresses()).password(this.elasticsearchConfigurationWrapper.password()).proxyConfig(this.createProxyConfig()).truststorePassword(this.elasticsearchConfigurationWrapper.truststorePassword()).truststorePath(this.elasticsearchConfigurationWrapper.truststorePath()).truststoreType(this.elasticsearchConfigurationWrapper.truststoreType()).userName(this.elasticsearchConfigurationWrapper.userName());
        return elasticsearchConnectionBuilder.build();
    }

    private String _getExceptionMessage(String message, String connectionId, boolean preferLocalCluster) {
        return StringBundler.concat((Object[])new Object[]{message, " Production Mode Enabled: ", this.elasticsearchConfigurationWrapper.isProductionModeEnabled(), ", Connection ID: ", connectionId, ", Prefer Local Cluster: ", preferLocalCluster, ", Cross-Cluster Replication Enabled: ", this.isCrossClusterReplicationEnabled(), ". Enable INFO logs on ", ElasticsearchConnectionManager.class, " for more information"});
    }

    private class ElasticsearchPortalInetSocketAddressEventListener
    implements PortalInetSocketAddressEventListener {
        private ElasticsearchPortalInetSocketAddressEventListener() {
        }

        public void portalLocalInetSocketAddressConfigured(InetSocketAddress inetSocketAddress, boolean secure) {
            ElasticsearchConnectionManager.this._portalInetSocketAddress = inetSocketAddress;
        }

        public void portalServerInetSocketAddressConfigured(InetSocketAddress inetSocketAddress, boolean secure) {
        }
    }
}

