/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;

public class ProxyConfig {
    private String _host;
    private String _password;
    private int _port;
    private boolean _shouldApplyConfig;
    private boolean _shouldApplyCredentials;
    private String _userName;

    public static Builder builder(Http http) {
        return new Builder(http);
    }

    public String getHost() {
        return this._host;
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean shouldApplyConfig() {
        return this._shouldApplyConfig;
    }

    public boolean shouldApplyCredentials() {
        return this._shouldApplyCredentials;
    }

    private ProxyConfig() {
    }

    private ProxyConfig(ProxyConfig proxyConfig) {
        this._shouldApplyConfig = proxyConfig._shouldApplyConfig;
        this._shouldApplyCredentials = proxyConfig._shouldApplyCredentials;
        this._host = proxyConfig._host;
        this._password = proxyConfig._password;
        this._port = proxyConfig._port;
        this._userName = proxyConfig._userName;
    }

    public static class Builder {
        private String _host = SystemProperties.get((String)"http.proxyHost");
        private final Http _http;
        private String[] _networkHostAddresses = new String[0];
        private String _password;
        private int _port = GetterUtil.getInteger((String)SystemProperties.get((String)"http.proxyPort"));
        private String _userName;

        public Builder(Http http) {
            this._http = http;
        }

        public ProxyConfig build() {
            ProxyConfig proxyConfig = new ProxyConfig();
            proxyConfig._host = this.getHost();
            proxyConfig._port = this.getPort();
            proxyConfig._shouldApplyConfig = this.shouldApplyConfig();
            proxyConfig._shouldApplyCredentials = this.shouldApplyCredentials();
            return proxyConfig;
        }

        public Builder host(String host) {
            if (!Validator.isBlank((String)host)) {
                this._host = host;
            }
            return this;
        }

        public Builder networkAddresses(String[] networkHostAddresses) {
            this._networkHostAddresses = networkHostAddresses;
            return this;
        }

        public Builder password(String password) {
            this._password = password;
            return this;
        }

        public Builder port(int port) {
            if (port > 0) {
                this._port = port;
            }
            return this;
        }

        public Builder userName(String userName) {
            this._userName = userName;
            return this;
        }

        protected String getHost() {
            return this._host;
        }

        protected int getPort() {
            return this._port;
        }

        protected boolean hasHostAndPort() {
            return !Validator.isBlank((String)this._host) && this._port > 0;
        }

        protected boolean shouldApplyConfig() {
            if (!this.hasHostAndPort()) {
                return false;
            }
            for (String networkHostAddress : this._networkHostAddresses) {
                if (!this._http.isNonProxyHost(HttpComponentsUtil.getDomain((String)networkHostAddress))) continue;
                return false;
            }
            return true;
        }

        protected boolean shouldApplyCredentials() {
            return this.shouldApplyConfig() && !Validator.isBlank((String)this._password) && !Validator.isBlank((String)this._userName);
        }
    }
}

