/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ProxyConfig;
import com.liferay.portal.search.elasticsearch7.internal.util.ClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class RestHighLevelClientFactory {
    private boolean _authenticationEnabled;
    private boolean _httpSSLEnabled;
    private int _maxConnections;
    private int _maxConnectionsPerRoute;
    private String[] _networkHostAddresses;
    private String _password;
    private ProxyConfig _proxyConfig;
    private String _truststorePassword;
    private String _truststorePath;
    private String _truststoreType;
    private String _userName;

    public static Builder builder() {
        return new Builder();
    }

    public RestHighLevelClient newRestHighLevelClient() {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this._getHttpHosts()).setDefaultHeaders(new Header[]{new BasicHeader("Accept", "application/vnd.elasticsearch+json;compatible-with=7"), new BasicHeader("Content-Type", "application/vnd.elasticsearch+json;compatible-with=7")}).setHttpClientConfigCallback(this::_customizeHttpClient).setRequestConfigCallback(this::_customizeRequestConfig);
        return ClassLoaderUtil.getWithContextClassLoader(() -> new RestHighLevelClient(restClientBuilder), this.getClass());
    }

    private RestHighLevelClientFactory() {
    }

    private RestHighLevelClientFactory(RestHighLevelClientFactory restHighLevelClientFactory) {
        this._authenticationEnabled = restHighLevelClientFactory._authenticationEnabled;
        this._httpSSLEnabled = restHighLevelClientFactory._httpSSLEnabled;
        this._maxConnections = restHighLevelClientFactory._maxConnections;
        this._maxConnectionsPerRoute = restHighLevelClientFactory._maxConnectionsPerRoute;
        this._networkHostAddresses = restHighLevelClientFactory._networkHostAddresses;
        this._password = restHighLevelClientFactory._password;
        this._truststorePassword = restHighLevelClientFactory._truststorePassword;
        this._truststorePath = restHighLevelClientFactory._truststorePath;
        this._truststoreType = restHighLevelClientFactory._truststoreType;
        this._proxyConfig = restHighLevelClientFactory._proxyConfig;
        this._userName = restHighLevelClientFactory._userName;
    }

    private CredentialsProvider _createCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this._proxyConfig.shouldApplyCredentials()) {
            credentialsProvider.setCredentials(new AuthScope(this._proxyConfig.getHost(), this._proxyConfig.getPort()), (Credentials)new UsernamePasswordCredentials(this._proxyConfig.getUserName(), this._proxyConfig.getPassword()));
        }
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this._userName, this._password));
        return credentialsProvider;
    }

    private SSLContext _createSSLContext() {
        try {
            Path path = Paths.get(this._truststorePath, new String[0]);
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            KeyStore keyStore = KeyStore.getInstance(this._truststoreType);
            keyStore.load(inputStream, this._truststorePassword.toCharArray());
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.loadKeyMaterial(keyStore, this._truststorePassword.toCharArray());
            sslContextBuilder.loadTrustMaterial(keyStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private HttpAsyncClientBuilder _customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this._authenticationEnabled) {
            httpClientBuilder.setDefaultCredentialsProvider(this._createCredentialsProvider());
        }
        if (this._httpSSLEnabled) {
            httpClientBuilder.setSSLContext(this._createSSLContext());
        }
        if (this._proxyConfig != null && this._proxyConfig.shouldApplyConfig()) {
            httpClientBuilder.setProxy(new HttpHost(this._proxyConfig.getHost(), this._proxyConfig.getPort(), "http"));
        }
        httpClientBuilder.disableAutomaticRetries();
        httpClientBuilder.disableConnectionState();
        httpClientBuilder.disableContentCompression();
        httpClientBuilder.disableCookieManagement();
        httpClientBuilder.disableDefaultUserAgent();
        httpClientBuilder.disableRedirectHandling();
        httpClientBuilder.setMaxConnPerRoute(this._maxConnectionsPerRoute);
        httpClientBuilder.setMaxConnTotal(this._maxConnections);
        final CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        final CloseableHttpAsyncClient closeableHttpAsyncClient = new CloseableHttpAsyncClient(){

            public void close() throws IOException {
                closeableHttpClient.close();
            }

            public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, FutureCallback<T> futureCallback) {
                BasicFuture basicFuture = new BasicFuture(futureCallback);
                try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpAsyncRequestProducer.getTarget(), httpAsyncRequestProducer.generateRequest(), httpContext);){
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    if (httpEntity != null) {
                        closeableHttpResponse.setEntity((HttpEntity)new BufferedHttpEntity(httpEntity));
                    }
                    basicFuture.completed((Object)closeableHttpResponse);
                }
                catch (Exception exception) {
                    basicFuture.failed(exception);
                }
                return basicFuture;
            }

            public boolean isRunning() {
                return true;
            }

            public void start() {
            }
        };
        return new HttpAsyncClientBuilder(){

            public CloseableHttpAsyncClient build() {
                return closeableHttpAsyncClient;
            }
        };
    }

    private RequestConfig.Builder _customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
        return requestConfigBuilder.setSocketTimeout(120000);
    }

    private HttpHost[] _getHttpHosts() {
        return (HttpHost[])TransformUtil.transform((Object[])this._networkHostAddresses, HttpHost::create, HttpHost.class);
    }

    static /* synthetic */ String[] access$502(RestHighLevelClientFactory x0, String[] x1) {
        x0._networkHostAddresses = x1;
        return x1;
    }

    public static class Builder {
        private final RestHighLevelClientFactory _restHighLevelClientFactory = new RestHighLevelClientFactory();

        public Builder authenticationEnabled(boolean authenticationEnabled) {
            this._restHighLevelClientFactory._authenticationEnabled = authenticationEnabled;
            return this;
        }

        public RestHighLevelClientFactory build() {
            return new RestHighLevelClientFactory(this._restHighLevelClientFactory);
        }

        public Builder httpSSLEnabled(boolean httpSSLEnabled) {
            this._restHighLevelClientFactory._httpSSLEnabled = httpSSLEnabled;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this._restHighLevelClientFactory._maxConnections = maxConnections;
            return this;
        }

        public Builder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this._restHighLevelClientFactory._maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder networkHostAddresses(String[] networkHostAddresses) {
            RestHighLevelClientFactory.access$502(this._restHighLevelClientFactory, networkHostAddresses);
            return this;
        }

        public Builder password(String password) {
            this._restHighLevelClientFactory._password = password;
            return this;
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this._restHighLevelClientFactory._proxyConfig = proxyConfig;
            return this;
        }

        public Builder truststorePassword(String truststorePassword) {
            this._restHighLevelClientFactory._truststorePassword = truststorePassword;
            return this;
        }

        public Builder truststorePath(String truststorePath) {
            this._restHighLevelClientFactory._truststorePath = truststorePath;
            return this;
        }

        public Builder truststoreType(String truststoreType) {
            this._restHighLevelClientFactory._truststoreType = truststoreType;
            return this;
        }

        public Builder userName(String userName) {
            this._restHighLevelClientFactory._userName = userName;
            return this;
        }
    }
}

