/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.RangeFacet;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.DateRangeAggregation;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessorContext;
import com.liferay.portal.search.facet.nested.NestedFacet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;

public class AggregationFilteringFacetProcessorContext
implements FacetProcessorContext {
    private final Map<String, List<QueryBuilder>> _selectionFiltersMap;

    public static FacetProcessorContext newInstance(Collection<Facet> facets) {
        return new AggregationFilteringFacetProcessorContext(AggregationFilteringFacetProcessorContext._getSelectionFiltersMap(facets));
    }

    @Override
    public AggregationBuilder postProcessAggregationBuilder(AggregationBuilder aggregationBuilder) {
        String aggregationName = aggregationBuilder.getName();
        AggregationBuilder superAggregationBuilder = this._getSuperAggregationBuilder(aggregationName);
        if (superAggregationBuilder != null) {
            return superAggregationBuilder.subAggregation(aggregationBuilder);
        }
        return aggregationBuilder;
    }

    private static void _addNestedFacetChildAggregationFilters(BoolQueryBuilder boolQueryBuilder, String fieldName, NestedFacet nestedFacet) {
        if (nestedFacet.getChildAggregation() instanceof DateRangeAggregation) {
            for (String value : nestedFacet.getSelections()) {
                DateRangeAggregation dateRangeAggregation = (DateRangeAggregation)nestedFacet.getChildAggregation();
                boolQueryBuilder.must(AggregationFilteringFacetProcessorContext._rangeQuery(fieldName, dateRangeAggregation.getFormat(), RangeParserUtil.parserRange((String)value)));
            }
        } else {
            Aggregation childAggregation = nestedFacet.getChildAggregation();
            Class<?> clazz = childAggregation.getClass();
            throw new UnsupportedOperationException("Nested facet does not support child aggregation " + clazz.getName());
        }
    }

    private static List<QueryBuilder> _getSelectionFilters(com.liferay.portal.search.facet.Facet facet) {
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        String fieldName = facet.getFieldName();
        if (facet instanceof NestedFacet) {
            NestedFacet nestedFacet = (NestedFacet)facet;
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            if (Validator.isNotNull((String)nestedFacet.getFilterField())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)nestedFacet.getFilterField(), (String[])new String[]{nestedFacet.getFilterValue()}));
            }
            if (nestedFacet.getChildAggregation() != null) {
                AggregationFilteringFacetProcessorContext._addNestedFacetChildAggregationFilters(boolQueryBuilder, fieldName, nestedFacet);
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)facet.getFieldName(), (String[])facet.getSelections()));
            }
            queryBuilders.add((QueryBuilder)QueryBuilders.nestedQuery((String)nestedFacet.getPath(), (QueryBuilder)boolQueryBuilder, (ScoreMode)ScoreMode.Total));
        } else if (facet instanceof RangeFacet) {
            for (String value : facet.getSelections()) {
                queryBuilders.add(AggregationFilteringFacetProcessorContext._rangeQuery(fieldName, null, RangeParserUtil.parserRange((String)value)));
            }
        } else {
            queryBuilders.add((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, (String[])facet.getSelections()));
        }
        return queryBuilders;
    }

    private static Map<String, List<QueryBuilder>> _getSelectionFiltersMap(Collection<Facet> facets) {
        HashMap<String, List<QueryBuilder>> map = new HashMap<String, List<QueryBuilder>>();
        for (Facet facet : facets) {
            com.liferay.portal.search.facet.Facet osgiFacet;
            if (!(facet instanceof com.liferay.portal.search.facet.Facet) || facet.isStatic() || ArrayUtil.isEmpty((Object[])(osgiFacet = (com.liferay.portal.search.facet.Facet)facet).getSelections())) continue;
            map.put(osgiFacet.getAggregationName(), AggregationFilteringFacetProcessorContext._getSelectionFilters(osgiFacet));
        }
        return map;
    }

    private static QueryBuilder _rangeQuery(String fieldName, String format, String[] rangeParts) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)fieldName);
        if (!Validator.isBlank((String)format)) {
            rangeQueryBuilder.format(format);
        }
        rangeQueryBuilder.from((Object)rangeParts[0]);
        rangeQueryBuilder.includeLower(true);
        rangeQueryBuilder.includeUpper(true);
        rangeQueryBuilder.to((Object)rangeParts[1]);
        return rangeQueryBuilder;
    }

    private AggregationFilteringFacetProcessorContext(Map<String, List<QueryBuilder>> selectionFiltersMap) {
        this._selectionFiltersMap = selectionFiltersMap;
    }

    private BoolQueryBuilder _getSelectionFiltersOfOthersAsBoolQueryBuilder(String aggregationName) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (Map.Entry<String, List<QueryBuilder>> entry : this._selectionFiltersMap.entrySet()) {
            String filterAggregationName = entry.getKey();
            if (filterAggregationName.equals(aggregationName)) continue;
            List<QueryBuilder> queryBuilders = entry.getValue();
            if (queryBuilders.size() == 1) {
                boolQueryBuilder.must(queryBuilders.get(0));
                continue;
            }
            if (queryBuilders.size() <= 1) continue;
            BoolQueryBuilder queryBuildersBoolQueryBuilder = QueryBuilders.boolQuery();
            for (QueryBuilder queryBuilder : queryBuilders) {
                queryBuildersBoolQueryBuilder.should(queryBuilder);
            }
            boolQueryBuilder.must((QueryBuilder)queryBuildersBoolQueryBuilder);
        }
        return boolQueryBuilder;
    }

    private AggregationBuilder _getSuperAggregationBuilder(String aggregationName) {
        if (this._selectionFiltersMap.isEmpty()) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = this._getSelectionFiltersOfOthersAsBoolQueryBuilder(aggregationName);
        if (!boolQueryBuilder.hasClauses()) {
            return null;
        }
        return new FilterAggregationBuilder(aggregationName, (QueryBuilder)boolQueryBuilder);
    }
}

