/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.facet.AggregationFilteringFacetProcessorContext;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessorContext;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetTranslator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FacetTranslator.class})
public class DefaultFacetTranslator
implements FacetTranslator {
    private final FacetProcessor<SearchRequestBuilder> _defaultFacetProcessor = new FacetProcessor<SearchRequestBuilder>(){

        @Override
        public AggregationBuilder processFacet(Facet facet) {
            int minDocCount;
            TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)FacetUtil.getAggregationName(facet));
            termsAggregationBuilder.field(facet.getFieldName());
            FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
            JSONObject dataJSONObject = facetConfiguration.getData();
            String include = dataJSONObject.getString("include", null);
            if (include != null) {
                termsAggregationBuilder.includeExclude(new IncludeExclude(include, null));
            }
            if ((minDocCount = dataJSONObject.getInt("frequencyThreshold", -1)) >= 0) {
                termsAggregationBuilder.minDocCount((long)minDocCount);
            }
            termsAggregationBuilder.order(BucketOrder.count((boolean)false));
            int size = dataJSONObject.getInt("maxTerms");
            if (size > 0) {
                termsAggregationBuilder.size(size);
            }
            return termsAggregationBuilder;
        }
    };
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private FilterTranslator<QueryBuilder> _filterTranslator;
    private ServiceTrackerMap<String, FacetProcessor> _serviceTrackerMap;

    @Override
    public void translate(SearchSourceBuilder searchSourceBuilder, Query query, Map<String, Facet> facetsMap, boolean basicFacetSelection) {
        if (MapUtil.isEmpty(facetsMap)) {
            return;
        }
        Collection<Facet> facets = facetsMap.values();
        FacetProcessorContext facetProcessorContext = this._getFacetProcessorContext(facets, basicFacetSelection);
        ArrayList<QueryBuilder> postFilterQueryBuilders = new ArrayList<QueryBuilder>();
        if (query != null && query.getPostFilter() != null) {
            postFilterQueryBuilders.add((QueryBuilder)this._filterTranslator.translate(query.getPostFilter(), null));
        }
        for (Facet facet : facets) {
            AggregationBuilder postProcessAggregationBuilder;
            AggregationBuilder aggregationBuilder;
            QueryBuilder postFilterQueryBuilder;
            if (facet.isStatic()) continue;
            BooleanClause booleanClause = facet.getFacetFilterBooleanClause();
            if (booleanClause != null && (postFilterQueryBuilder = this._translateBooleanClause((BooleanClause<Filter>)booleanClause)) != null) {
                postFilterQueryBuilders.add(postFilterQueryBuilder);
            }
            if ((aggregationBuilder = this._processFacet(facet)) == null || (postProcessAggregationBuilder = this.postProcessAggregationBuilder(aggregationBuilder, facetProcessorContext)) == null) continue;
            searchSourceBuilder.aggregation(postProcessAggregationBuilder);
        }
        if (ListUtil.isNotEmpty(postFilterQueryBuilders)) {
            searchSourceBuilder.postFilter(this._getPostFilter(postFilterQueryBuilders));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FacetProcessor.class, (String)"(&(class.name=*)(!(class.name=DEFAULT)))", (serviceReference, emitter) -> {
            List classNames = StringUtil.asList((Object)serviceReference.getProperty("class.name"));
            for (String className : classNames) {
                emitter.emit((Object)className);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected AggregationBuilder postProcessAggregationBuilder(AggregationBuilder aggregationBuilder, FacetProcessorContext facetProcessorContext) {
        if (facetProcessorContext != null) {
            return facetProcessorContext.postProcessAggregationBuilder(aggregationBuilder);
        }
        return aggregationBuilder;
    }

    private FacetProcessorContext _getFacetProcessorContext(Collection<Facet> facets, boolean basicFacetSelection) {
        if (basicFacetSelection) {
            return null;
        }
        return AggregationFilteringFacetProcessorContext.newInstance(facets);
    }

    private QueryBuilder _getPostFilter(List<QueryBuilder> queryBuilders) {
        if (queryBuilders.size() == 1) {
            return queryBuilders.get(0);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : queryBuilders) {
            boolQueryBuilder.must(queryBuilder);
        }
        return boolQueryBuilder;
    }

    private AggregationBuilder _processFacet(Facet facet) {
        Class<?> clazz = facet.getClass();
        FacetProcessor<SearchRequestBuilder> facetProcessor = (FacetProcessor<SearchRequestBuilder>)this._serviceTrackerMap.getService((Object)clazz.getName());
        if (facetProcessor == null) {
            facetProcessor = this._defaultFacetProcessor;
        }
        return facetProcessor.processFacet(facet);
    }

    private QueryBuilder _translateBooleanClause(BooleanClause<Filter> booleanClause) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
        return (QueryBuilder)this._filterTranslator.translate((Filter)booleanFilter, null);
    }
}

