/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.DateRangeAggregation;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import com.liferay.portal.search.facet.nested.NestedFacet;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(property={"class.name=com.liferay.portal.search.internal.facet.NestedFacetImpl"}, service={FacetProcessor.class})
public class NestedFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public AggregationBuilder processFacet(Facet facet) {
        if (!(facet instanceof NestedFacet)) {
            return null;
        }
        NestedFacet nestedFacet = (NestedFacet)facet;
        NestedAggregationBuilder nestedAggregationBuilder = AggregationBuilders.nested((String)FacetUtil.getAggregationName(facet), (String)nestedFacet.getPath());
        TermsAggregationBuilder termsAggregationBuilder = this._getTermsAggregationBuilder(nestedFacet);
        if (nestedFacet.getChildAggregation() != null || Validator.isNotNull((String)nestedFacet.getFilterField())) {
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)nestedFacet.getFilterField(), (String)nestedFacet.getFilterValue());
            FilterAggregationBuilder filterAggregationBuilder = AggregationBuilders.filter((String)FacetUtil.getAggregationName(facet), (QueryBuilder)termQueryBuilder);
            if (nestedFacet.getChildAggregation() != null) {
                filterAggregationBuilder.subAggregation(this._getChildAggregationBuilder(nestedFacet.getChildAggregation()));
            } else {
                filterAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder);
            }
            nestedAggregationBuilder.subAggregation((AggregationBuilder)filterAggregationBuilder);
        } else {
            nestedAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder);
        }
        return nestedAggregationBuilder;
    }

    private AggregationBuilder _getChildAggregationBuilder(Aggregation aggregation) {
        if (aggregation instanceof DateRangeAggregation) {
            return this._getDateRangeAggregationBuilder((DateRangeAggregation)aggregation);
        }
        Class<?> clazz = aggregation.getClass();
        throw new UnsupportedOperationException("Nested facet does not support child aggregation " + clazz.getName());
    }

    private AggregationBuilder _getDateRangeAggregationBuilder(DateRangeAggregation dateRangeAggregation) {
        DateRangeAggregationBuilder dateRangeAggregationBuilder = AggregationBuilders.dateRange((String)dateRangeAggregation.getName());
        dateRangeAggregationBuilder.field(dateRangeAggregation.getField());
        dateRangeAggregationBuilder.format(dateRangeAggregation.getFormat());
        for (Range range : dateRangeAggregation.getRanges()) {
            dateRangeAggregationBuilder.addRange(range.getKey(), range.getFromAsString(), range.getToAsString());
        }
        return dateRangeAggregationBuilder;
    }

    private TermsAggregationBuilder _getTermsAggregationBuilder(NestedFacet nestedFacet) {
        int size;
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)FacetUtil.getAggregationName((Facet)nestedFacet));
        termsAggregationBuilder.field(nestedFacet.getFieldName());
        FacetConfiguration facetConfiguration = nestedFacet.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        int minDocCount = dataJSONObject.getInt("frequencyThreshold", -1);
        if (minDocCount >= 0) {
            termsAggregationBuilder.minDocCount((long)minDocCount);
        }
        if ((size = dataJSONObject.getInt("maxTerms")) > 0) {
            termsAggregationBuilder.size(size);
        }
        return termsAggregationBuilder;
    }
}

