/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.osgi.service.component.annotations.Component;

@Component(property={"class.name=com.liferay.portal.kernel.search.facet.RangeFacet", "class.name=com.liferay.portal.search.internal.facet.ModifiedFacetImpl", "class.name=com.liferay.portal.search.internal.facet.RangeFacetImpl"}, service={FacetProcessor.class})
public class RangeFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public AggregationBuilder processFacet(Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        AbstractRangeBuilder abstractRangeBuilder = this.getRangeBuilder(FacetUtil.getAggregationName(facet));
        abstractRangeBuilder.field(facetConfiguration.getFieldName());
        JSONObject jsonObject = facetConfiguration.getData();
        String format = jsonObject.getString("format");
        if (Validator.isNotNull((String)format)) {
            abstractRangeBuilder.format(format);
        }
        this._addRanges(facetConfiguration, abstractRangeBuilder);
        if (ListUtil.isEmpty((List)abstractRangeBuilder.ranges())) {
            return null;
        }
        return abstractRangeBuilder;
    }

    protected AbstractRangeBuilder getRangeBuilder(String name) {
        return AggregationBuilders.range((String)name);
    }

    private void _addRange(AbstractRangeBuilder abstractRangeBuilder, String range) {
        String[] rangeParts = RangeParserUtil.parserRange((String)range);
        abstractRangeBuilder.addRange(new RangeAggregator.Range(range, rangeParts[0], rangeParts[1]));
    }

    private void _addRanges(FacetConfiguration facetConfiguration, AbstractRangeBuilder abstractRangeBuilder) {
        JSONObject jsonObject = facetConfiguration.getData();
        JSONArray jsonArray = jsonObject.getJSONArray("ranges");
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject rangeJSONObject = jsonArray.getJSONObject(i);
            this._addRange(abstractRangeBuilder, rangeJSONObject.getString("range"));
        }
    }
}

