/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.geolocation;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.search.geolocation.CircleShape;
import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.EnvelopeShape;
import com.liferay.portal.search.geolocation.GeoDistance;
import com.liferay.portal.search.geolocation.GeometryCollectionShape;
import com.liferay.portal.search.geolocation.LineStringShape;
import com.liferay.portal.search.geolocation.MultiLineStringShape;
import com.liferay.portal.search.geolocation.MultiPointShape;
import com.liferay.portal.search.geolocation.MultiPolygonShape;
import com.liferay.portal.search.geolocation.Orientation;
import com.liferay.portal.search.geolocation.PointShape;
import com.liferay.portal.search.geolocation.PolygonShape;
import com.liferay.portal.search.geolocation.Shape;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import java.util.List;
import org.elasticsearch.legacygeo.builders.CircleBuilder;
import org.elasticsearch.legacygeo.builders.EnvelopeBuilder;
import org.elasticsearch.legacygeo.builders.GeometryCollectionBuilder;
import org.elasticsearch.legacygeo.builders.LineStringBuilder;
import org.elasticsearch.legacygeo.builders.MultiLineStringBuilder;
import org.elasticsearch.legacygeo.builders.MultiPointBuilder;
import org.elasticsearch.legacygeo.builders.MultiPolygonBuilder;
import org.elasticsearch.legacygeo.builders.PointBuilder;
import org.elasticsearch.legacygeo.builders.PolygonBuilder;
import org.elasticsearch.legacygeo.builders.ShapeBuilder;

public class ElasticsearchShapeTranslator
implements ShapeTranslator<ShapeBuilder<?, ?, ?>> {
    public CircleBuilder translate(CircleShape circleShape) {
        GeoDistance radiusGeoDistance = circleShape.getRadius();
        return ((CircleBuilder)new CircleBuilder().center(this.translate(circleShape.getCenter())).coordinates(this.translate(circleShape.getCoordinates()))).radius(radiusGeoDistance.getDistance(), String.valueOf(radiusGeoDistance.getDistanceUnit()));
    }

    public EnvelopeBuilder translate(EnvelopeShape envelopeShape) {
        return (EnvelopeBuilder)new EnvelopeBuilder(this.translate(envelopeShape.getTopLeft()), this.translate(envelopeShape.getBottomRight())).coordinates(this.translate(envelopeShape.getCoordinates()));
    }

    public GeometryCollectionBuilder translate(GeometryCollectionShape geometryCollectionShape) {
        GeometryCollectionBuilder geometryCollectionBuilder = new GeometryCollectionBuilder();
        geometryCollectionBuilder.coordinates(this.translate(geometryCollectionShape.getCoordinates()));
        for (Shape shape : geometryCollectionShape.getShapes()) {
            geometryCollectionBuilder.shape(this.translate(shape));
        }
        return geometryCollectionBuilder;
    }

    public LineStringBuilder translate(LineStringShape lineStringShape) {
        return new LineStringBuilder(this.translate(lineStringShape.getCoordinates()));
    }

    public MultiLineStringBuilder translate(MultiLineStringShape multiLineStringShape) {
        MultiLineStringBuilder multiLineStringBuilder = new MultiLineStringBuilder();
        multiLineStringBuilder.coordinates(this.translate(multiLineStringShape.getCoordinates()));
        for (LineStringShape lineStringShape : multiLineStringShape.getLineStringShapes()) {
            multiLineStringBuilder.linestring(this.translate(lineStringShape));
        }
        return multiLineStringBuilder;
    }

    public MultiPointBuilder translate(MultiPointShape multiPointShape) {
        return new MultiPointBuilder(this.translate(multiPointShape.getCoordinates()));
    }

    public MultiPolygonBuilder translate(MultiPolygonShape multiPolygonShape) {
        MultiPolygonBuilder multiPolygonBuilder = new MultiPolygonBuilder(this.translate(multiPolygonShape.getOrientation()));
        multiPolygonBuilder.coordinates(this.translate(multiPolygonShape.getCoordinates()));
        for (PolygonShape polygonShape : multiPolygonShape.getPolygonShapes()) {
            multiPolygonBuilder.polygon(this.translate(polygonShape));
        }
        return multiPolygonBuilder;
    }

    public PointBuilder translate(PointShape pointShape) {
        PointBuilder pointBuilder = new PointBuilder();
        for (Coordinate coordinate : pointShape.getCoordinates()) {
            pointBuilder.coordinate(this.translate(coordinate));
        }
        return pointBuilder;
    }

    public PolygonBuilder translate(PolygonShape polygonShape) {
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.translate(polygonShape.getShell()), this.translate(polygonShape.getOrientation()));
        polygonBuilder.coordinates(this.translate(polygonShape.getCoordinates()));
        for (LineStringShape holeLineStringShape : polygonShape.getHoles()) {
            polygonBuilder.hole(this.translate(holeLineStringShape));
        }
        return polygonBuilder;
    }

    protected org.locationtech.jts.geom.Coordinate translate(Coordinate coordinate) {
        return new org.locationtech.jts.geom.Coordinate(coordinate.getX(), coordinate.getY(), coordinate.getZ());
    }

    protected List<org.locationtech.jts.geom.Coordinate> translate(List<Coordinate> coordinates) {
        return TransformUtil.transform(coordinates, this::translate);
    }

    protected org.elasticsearch.common.geo.Orientation translate(Orientation orientation) {
        if (orientation == Orientation.LEFT) {
            return org.elasticsearch.common.geo.Orientation.LEFT;
        }
        if (orientation == Orientation.RIGHT) {
            return org.elasticsearch.common.geo.Orientation.RIGHT;
        }
        throw new IllegalArgumentException("Invalid Orientation: " + orientation);
    }

    protected ShapeBuilder<?, ?, ?> translate(Shape shape) {
        return (ShapeBuilder)shape.accept((ShapeTranslator)this);
    }
}

